package com.xdja.safeclient.wrapper;

import android.content.Context;

import com.xdja.safeclient.utils.DPUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;

/**
 * Description:Pin码相关的一些操作
 * Created by zjc on 2017/1/16 0016.
 */
public class PinWrapper {

    public static final String DEFAULT_PIN = "111111";

    public static boolean verifyPinLength(String pin) {
        return (!pin.equals("")) &&
                (pin.length() >= 3) &&
                (pin.length() <= 16);
    }

    public static void savePin(Context context, String pin) {
        DPUtil.savePin(context, pin);
    }

    public static void savePin(Context context, byte[] pin) {
        DPUtil.savePin(context, pin);
    }

    /**
     * 获取保存的Pin码
     *
     * @param context
     * @return 没有保存过Pin码返回null
     */
    public static String getPin(Context context) {
        return DPUtil.getPin(context);
    }

    public static boolean deletePin(Context context) {
        return DPUtil.deletePin(context);
    }

    public static boolean getNeedSavePin(Context context) {
        return SharedPreferencesUtil.get(context, "savepin", "false").equals("true");
    }

    public static void setNeedSavePin(Context context, boolean save) {
        //这个地方其实是应该直接存储boolean值的，但是因为历史遗留问题，为了保持兼容性并且不出错，所以还是存储String值
        SharedPreferencesUtil.put(context, "savepin", save ? "true" : "false");
    }


}
