package com.xdja.safeclient.wrapper;

import android.content.Context;

import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.SharedPreferencesUtil;

/**
 * Description:
 * Created by Administrator on 2017/1/19 0019.
 */
public class QuitWrapper {

    public static final String QUIT = "quit";

    public static final String TAG = "QuitWrapper";

    /**
     * 用户点击退出的时候，标识用户已经退出
     *
     * @param context
     */
    public static void setHasBeenQuit(Context context) {
        Log.d(TAG, "set quit flag");
        SharedPreferencesUtil.put(context, QUIT, true);
    }

    /**
     * 重置退出标识
     * 注意：现在的退出处理是是不完全退出进程的
     * 所以，退出时候再进入是不会走到Application初始化流程的
     *
     * @param context
     */
    public static void resetHasBeenQuit(Context context) {
        Log.d(TAG, "reset quit flag");
        SharedPreferencesUtil.put(context, QUIT, false);
    }

    /**
     * 判断是否已经手动点击过退出
     *
     * @param context
     * @return
     */
    public static boolean getHasBeenQuit(Context context) {
        return (boolean) SharedPreferencesUtil.get(context, QUIT, false);
    }


}
