package com.xdja.sslvpn;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService.Builder;
import android.os.Build.VERSION;
import android.os.PowerManager;
import android.os.PowerManager.WakeLock;
import android.text.TextUtils;

import com.xdja.safeclient.utils.Log;

import com.xdja.safeclient.Function;
import com.xdja.safeclient.GuardianHelper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.SharedPreferencesUtil;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;

public class SSLVPN {

    private int hHandle = 0;
    private static final String TAG = "sslvpn";

    PowerManager pm = null;
    WakeLock mWakeLock = null;

    public static final int LANGUAGE_ZH = 0;
    public static final int LANGUAGE_EN = 1;

    public AppAclList getAppAclList() {
        return appAclList;
    }

    private AppAclList appAclList = new AppAclList();

    public SSLVPN() {
        hHandle = init();
    }

    /**
     * 更新底层库的语言设置 xjq,2017-02-14 14:07:05
     */
    public static void setLocale(Locale locale) {

        String lan = locale.getLanguage();
        switch (lan) {
            // TODO: 2018/2/9 0009 怀疑这个地方有问题，导致华为手机上的BUG
            case "en":
                SSLVPN.setNativeLanguage(1);
                break;
            case "zh":
                SSLVPN.setNativeLanguage(0);
                break;
            default:
                SSLVPN.setNativeLanguage(0);
                break;
        }
    }

    /**
     * 设置sslvpn模块参数
     *
     * @param sslClientConfig 模块参数
     * @return 0成功，其他失败
     */
    public int setParam(SslClientConfig sslClientConfig) {
        return setParam(hHandle, sslClientConfig);
    }

    /**
     * 启动服务
     *
     * @return 0成功，其他失败
     */
    public int startService() {
        return startService(hHandle);
    }

    /**
     * 获取sslvpn当前状态
     *
     * @param sslvpnStatus sslvpn状态
     * @return 0成功，其他失败
     */
    public int getStatus(SslvpnStatus sslvpnStatus) {
        return getStatus(hHandle, sslvpnStatus);
    }

    /**
     * 停止服务
     *
     * @return 0成功，其他失败
     */
    public int stopService() {
        return stopService(hHandle);
    }

    /**
     * 释放sslvpn模块中资源
     *
     * @return 0成功，其他失败
     */
    public int release() {
        release(hHandle);
        hHandle = 0;
        return 0;
    }


    public int guardianLearn(int opt, long data) {
        Log.d(TAG, "guardianLearn opt:" + opt + " data:" + data);
        return guardianLearn(hHandle, opt, data);
    }

    public void guardianAdvise(int second) {
        Log.d(TAG, "guardianAdvise second:" + second);
        if (MyApplication.myApplication == null) {
            return;
        }

        // 防止频繁唤醒系统
        if (second <= 200) {
            return;
        }
        // 防止唤醒手机造成应用高耗电 2016-05-10 zhaoxiaolong
        GuardianHelper.invokeOnceAlarm(MyApplication.myApplication.getApplicationContext(), second);
    }

    public static int startXdjaKeyService(String packageName, int keyType, Object extra) {
        Log.d("SSLVPN", "startXdjaKeyService");
        return startXdjaKeyServer(packageName, keyType, extra);
    }

    public static int stopXdjaKeyService() {
        return stopXdjaKeyServer();
    }

    public static int setNativeLanguage(int lan) {
        return setLanguage(lan);
    }

    private int addAddress(String addr, int prefixLen, int mtu) {
        Builder builder = null;

        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }

        try {
            if (TunVpnService.mInterface != null) {
                Log.d(TAG, "TunVpnService.mInterface.close");
                TunVpnService.mInterface.close();
                TunVpnService.mInterface = null;
                TunVpnService.tunVpnObj.destroyBuilder();
            }
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        TunVpnService.tunVpnObj.destroyBuilder();
        builder = TunVpnService.tunVpnObj.createBuilder();

        if (MyApplication.myApplication.sslvpn != null) {
            MyApplication.myApplication.sslvpn.closeTunFd();
        }

        Log.d(TAG, "addAddress " + addr + " " + prefixLen);
        Log.d(TAG, "addAddress mtu ：" + mtu);

        try {
            builder.addAddress(addr, prefixLen);
            builder.setMtu(mtu);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }

        return 0;
    }


    private int addRoute(String addr, int prefixLen) {

        Builder builder = null;

        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }

        builder = TunVpnService.tunVpnObj.getBuilder();

        if (builder == null) {
            builder = TunVpnService.tunVpnObj.createBuilder();
        }

        if (MyApplication.myApplication.propertiesConfig.getDisablePublicNetwork() == 1) {
            Log.d(TAG, "Disable public network. Add route 0.0.0.0/0");
            addr = "0.0.0.0";
            prefixLen = 0;
        }

        Log.d(TAG, "addRoute " + addr + " " + prefixLen);
        try {
            builder.addRoute(addr, prefixLen);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }

        return 0;
    }


    private int configTun() {
        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }

        return TunVpnService.tunVpnObj.getTunFd();
    }

    private void setSessionId(String id) {
        TunVpnService.setSessionId(id);
    }

    public int setTunFd(int fd) {
        return setTunFd(hHandle, fd);
    }

    private native int setTunFd(int hHandle, int fd);

    /**
     * 获取ssl socket fd. Add by xjq, 2017-3-23 19:48:01
     * @return socket fd
     */
    public int getSSLSocketFd() {
        return getSSLSocketFd(hHandle);
    }
    private native int getSSLSocketFd(int hHandle);

    public void closeTunFd() {
        closeTunFd(hHandle);
    }

    private native int closeTunFd(int hHandle);

    private void getWakeLock() {
        pm = (PowerManager) MyApplication.myApplication.getSystemService(Context.POWER_SERVICE);
        mWakeLock = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "XYTEST");
        Log.d(TAG, "mWakeLock.acquire");
        mWakeLock.acquire();
    }

    private void releaseWakeLock() {
        Log.d(TAG, "mWakeLock.release");
        if (mWakeLock != null) {
            mWakeLock.release();
        }
    }

    private String getIpAddress() {
        String ipAddr = null;
        String gateWayIp = null;
        if (MyApplication.myApplication.propertiesConfig.getmHuNanJwt() == 0) {
            return null;
        }

        Log.d(TAG, "version for HuNan Jwt");

        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface intf = en.nextElement();
                for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (!inetAddress.isLoopbackAddress() && inetAddress instanceof Inet4Address) {
                        // if (!inetAddress.isLoopbackAddress() && inetAddress instanceof Inet6Address) {
                        Log.d(TAG, "hostAddr = " + inetAddress.getHostAddress().toString());
                        ipAddr = inetAddress.getHostAddress().toString();
                        break;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (ipAddr == null) {
            return null;
        } else {
            Log.d(TAG, "ipAddr = " + ipAddr);
            String[] temp = ipAddr.split("\\.");
            if (temp.length < 4) {
                return null;
            }
            if (temp[0].equals("10")) {
                if (temp[1].equals("2")) {
                    //3G
                    //地址池：
                    //10.2.58.1/24
                    //10.2.144.1/20
                    //10..2160.1/20
                    //10.2.176.1/21
                    //    				gateWayIp = "172.30.1.2";
                    gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
                } else if (temp[1].equals("0")) {
                    //4G
                    //10.0.20.0/24~ 10.0.60.0/24
                    //gateWayIp = "172.168.16.18";
                    gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp2());
                }
            }
        }
        if (gateWayIp != null) {
            Log.d(TAG, "gateWayIp = " + gateWayIp);
        }

        return gateWayIp;
    }

    //根据运营商选择网关地址，第一个IP：中国移动，第二个IP：中国联通，第三个IP：中国电信，如果第二第三个地址为空则使用第一个地址。
    private String getIpAddrByProviders() {
        //// TODO: 2017/3/1
//        ToastUtil.show(MyApplication.myApplication, "根据运营商选择网关地址");
        String gateWayIp = null;
        if (MyApplication.myApplication.propertiesConfig.getPickIpByProviders() == 0) {
            return null;
        }

        if (Compatibility.isZhangJiaJieBase()) {

//            ToastUtil.show(MyApplication.myApplication, "张家界电信");

            String ip = Function.getIP();

            if (!TextUtils.isEmpty(ip)) {
                String[] ipParams = ip.split(".");
                if (ipParams.length == 4) {
                    String firstIp = ipParams[0];
                    String secondIp = ipParams[1];
                    String thirdIp = ipParams[2];
                    String fourthIp = ipParams[3];

                    // TODO: 2017/3/1 测试代码
//                    ToastUtil.show(MyApplication.myApplication, ip);

                    // TODO: 2017/3/1 这个地方先用字符串匹配，之后改成正则
                    // 张家界移动的IP地址池192.168.0.0 - 192.168.7.254
                    // 张家界电信的IP地址池172.16.0.0 - 172.16.7.255
                    if (firstIp.equals("192") && secondIp.equals("168")) {
                        if (Integer.parseInt(thirdIp) >= 0 && Integer.parseInt(thirdIp) <= 7) {
                            if (Integer.parseInt(fourthIp) >= 0 && Integer.parseInt(fourthIp) <= 254) {
                                gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
                                Log.d(TAG, "ZhangJiajie China Mobile    " + ip);
                            }
                        }
                    }

                    if (firstIp.equals("172") && secondIp.equals("16")) {
                        if (Integer.parseInt(thirdIp) >= 0 && Integer.parseInt(thirdIp) <= 7) {
                            if (Integer.parseInt(fourthIp) >= 0 && Integer.parseInt(fourthIp) <= 255) {
                                gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp3());
                                Log.d(TAG, "ZhangJiajie China Telecome  " + ip);
                            }
                        }
                    }


                } else {
                    Log.e(TAG, "IP format invalid");
                }
            } else {
                Log.e(TAG, "IP address is null");
                return null;
            }


        } else {
            Log.d(TAG, "version for zz Jwt");

            String provider = Function.getProvidersName(MyApplication.myApplication.getApplicationContext());

            if (provider != null) {
                if (provider.equals("中国移动")) {
                    gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
                } else if (provider.equals("中国联通")) {
                    gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp2());
                } else if (provider.equals("中国电信")) {
                    gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp3());
                } else {
                    gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
                }
            }

            if (gateWayIp == null) {
                gateWayIp = new String(MyApplication.myApplication.sslClientConfig.getGateWayIp());
            }
        }


        return gateWayIp;
    }

    private void startVpn(Context context) {

        MyApplication myApplication = MyApplication.myApplication;

        if (myApplication == null) {
            Log.e(TAG, "startVpn,myApplication == null");
        }

        if (myApplication.sslClientConfig.getTransportMode() == 0) {
            Intent intent = new Intent();
            intent.setClassName(context.getPackageName(), "com.xdja.safeclient.VpnService");
            context.startService(intent);

            //			if (VpnService.sslStageList != null) {
            //				VpnService.sslStageList.clear();
            //			}
            //
            //			if (SafeVerifyActivity.myAdapter!=null) {
            //				SafeVerifyActivity.myAdapter.notifyDataSetChanged();
            //			}
        } else {
            ComponentName componetName = new ComponentName(
                    //这个是另外一个应用程序的包名
                    context.getPackageName(),
                    //这个参数是要启动的Activity
                    "com.xdja.safeclient.activity.StartVpnActivity");

            try {
                Intent intent = new Intent();
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.setComponent(componetName);
                context.startActivity(intent);
            } catch (Exception e) {
                e.printStackTrace();
            }

            //			if (TunVpnService.sslStageList != null) {
            //				TunVpnService.sslStageList.clear();
            //			}

            //			if (SafeVerifyActivity.myTunAdapter!=null) {
            //				SafeVerifyActivity.myTunAdapter.notifyDataSetChanged();
            //			}
        }
    }

    public void stopVpn() {
        MyApplication myApplication = MyApplication.myApplication;

        //转发模式
        if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode) {
            //			VpnService.startService = false;
            Function.setSafeVpnState(myApplication.getApplicationContext(), false);
            VpnService.stopService = true;
            stopVpnService(myApplication);
        }
        //隧道模式
        else {
            stopTunVpnService(myApplication);
        }
    }

    public void stopVpnService(MyApplication myApplication) {
        boolean res = false;

        Log.d(TAG, "stop VpnService...");
        Intent intent = new Intent();
        intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
        res = myApplication.stopService(intent);

        if (res == false) {
            Log.e(TAG, "stop VpnService failed");
        } else {
            Log.d(TAG, "stop VpnService success ");
        }
    }

    public void stopTunVpnService(MyApplication myApplication) {
        Log.d(TAG, "stop TunVpnService...");

        if (myApplication == null) {
            Log.e(TAG, "myApplication == null");
        }

        try {
            boolean res = false;
            try {
                if (TunVpnService.mInterface != null) {
                    Log.d(TAG, "TunVpnService.mInterface.close");
                    TunVpnService.mInterface.close();
                    TunVpnService.mInterface = null;
                    if (TunVpnService.tunVpnObj != null) {
                        TunVpnService.tunVpnObj.destroyBuilder();
                    }
                }
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

            if (myApplication.sslvpn != null) {
                myApplication.sslvpn.closeTunFd();
            }

            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");
            res = myApplication.stopService(intent);

            if (res == false) {
                Log.e(TAG, "stop TunVpnService failed");
            } else {
                Log.d(TAG, "stop TunVpnService success ");
            }

        } catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    void restartVpnService() {
        if (VERSION.SDK_INT >= 23) {
            return;
        }

        MyApplication myApplication = MyApplication.myApplication;

        if (myApplication.propertiesConfig != null && myApplication.propertiesConfig.getIsWakeLock() == 1) {
            return;
        }

        if (VpnService.FORWARD_MODE != myApplication.sslClientConfig.transportMode) {
            return;
        }

        Log.d(TAG, "restart Vpn Service");

        if (SafeVerifyActivity.stopBtnClick == true) {
            return;
        }

        stopVpn();
        Log.d(TAG, "stopVpn");
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        Log.d(TAG, "startVpn");
        startVpn(MyApplication.myApplication.getApplicationContext());
    }

    String codeConvert(String in) {

        String out;
        Log.d(TAG, "codeConvert, in = " + in);
        try {
            //out = new String(in.getBytes("utf-8"),"gbk");
            String utf8 = new String(in.getBytes("utf-8"));
            Log.d(TAG, "codeConvert, utf8 = " + utf8);

            String unicode = new String(utf8.getBytes(), "utf-8");
            Log.d(TAG, "codeConvert, unicode = " + unicode);

            out = new String(in.getBytes("GBK"));

            Log.d(TAG, "codeConvert, out = " + out);
            return out;
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return null;
        }
    }

    void notifySateChange(int len, byte[] state) throws UnsupportedEncodingException {
        if (len > 0) {
            if (VpnService.FORWARD_MODE == MyApplication.myApplication.sslClientConfig.transportMode) {
                VpnService.vpnObject.stateChange(Arrays.copyOfRange(state, 4, len), len - 4);
            } else {
                TunVpnService.tunVpnObj.stateChange(Arrays.copyOfRange(state, 4, len), len - 4);
            }
        }
    }

    /**
     * 功能: 初始化SSLVPN，分配所需资源
     * <p>
     * 返回值： 返回SSLVPN句柄
     */
    private native int init();

    /**
     * 设置参数
     *
     * @param hHandle         sslvpn句柄
     * @param sslClientConfig sslvpn配置对象
     * @return 成功返回值0，失败返回其他
     */
    private native int setParam(int hHandle, SslClientConfig sslClientConfig);

    /**
     * 功能: 启动命令服务 返回值: 成功返回0
     */
    private native int startService(int hHandle);

    /**
     * 获取当前状态
     *
     * @param hHandle      sslvpn句柄
     * @param sslvpnStatus sslvpn状态对象
     * @return
     */
    private native int getStatus(int hHandle, SslvpnStatus sslvpnStatus);

    /**
     * 功能: 停止命令服务 返回值: 无
     */
    private native int stopService(int hHandle);

    /**
     * 功能: 释放SSLVPN中资源 返回值： 无
     */
    private native int release(int hHandle);

    /**
     * 功能: 启动XdjaKeyServer 返回值： 无
     */
    private static native int startXdjaKeyServer(String packageName, int keyType, Object extra);

    /**
     * 功能: 停止XdjaKeyServer 返回值： 无
     */
    private static native int stopXdjaKeyServer();

    private static native int setLanguage(int lan);

    private native int guardianLearn(int hHandle, int opt, long data);

    public static native void initVPN(String pacakgeName, String filesDir, int language, int bindAllIP, int disablePublicNetwork);

    private native byte[] excuteCmd(int hHandle, String cmd);

    private native void syncErrorState(int hHandle, int errCode);

    private native void notifyNetworkReconnect(int hHandle, int connected);

    public static native int parsePKCS12(String file, String password, byte[] cert, int[] certSize,
                                         byte[] prikey, int[] prikeySize);

    public void notifyNetworkReconnect(int connected) {
        notifyNetworkReconnect(hHandle, connected);
    }

    /**
     * 同步上层错误状态到本地层  xjq, 2017-03-16 10:19:03
     * @param errCode
     */
    public void syncErrorState(int errCode) {
        syncErrorState(hHandle, errCode);
    }
    /**
     * 执行CMD命令并返回结果
     * @param cmd
     * @return
     */
    public String excuteOuterCmd(String cmd) {
        byte[] resultArray = excuteCmd(hHandle, cmd);

        String result = null;
        try {
            result = new String(resultArray,"gbk");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }


        if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUOSHUI) {

            if (MyApplication.myApplication != null) {

                Context context = MyApplication.myApplication.getApplicationContext();

                if (cmd.equals("GETSTATUS") && !TextUtils.isEmpty(result)) {
                    String[] commentArray = result.split(" ");
                    String resultStr, stageStr, errCodeStr;

                    resultStr = commentArray[0];
                    stageStr = commentArray[1];
                    errCodeStr= commentArray[2];


                    if (resultStr.equals("FAILED") && errCodeStr.equals("-97")) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(resultStr).append(" ")
                                .append(stageStr).append(" ")
                                .append(errCodeStr).append(" ")
                                .append(context.getString(R.string.guoshui_key_not_exist));

                        return sb.toString();
                    }

                }
            }
        }

        return result;
    }



    //add by wangyue 添加虚拟网卡DNS 广州市局要求
    private int addDnsServer(String addr) {

        Builder builder = null;

        if (TunVpnService.tunVpnObj == null) {
            return -1;
        }

        builder = TunVpnService.tunVpnObj.getBuilder();

        if (builder == null) {
            builder = TunVpnService.tunVpnObj.createBuilder();
        }

        Log.d(TAG, "addDnsServer " + addr);
        try {
            builder.addDnsServer(addr);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return -1;
        }

        return 0;
    }


    /**
     * 设置默认选择的网关IP配置 Add by xjq, 2017-5-3 15:11:57
     * @param index
     * @return`
     */
    private int setPreferedGatewayIndex(int index) {
        MyApplication application = MyApplication.myApplication;
        if (application == null) {
            Log.e(TAG, "setPreferedGatewayIPIndex application == null.");
            return -1;
        }

        Log.d(TAG, "setPreferedGatewayIPIndex index = " + index);
        SharedPreferencesUtil.put(application, CONSTANT.PREFERED_GATEWAY_INDEX, index);
        return 0;
    }

    /**
     * 获取默认选择的网关配置 Add by xjq, 2017-5-3 15:12:03
     * @return
     */
    private int getPreferedGatewayIndex() {

        // 贵阳市局要求默认连接第一个网关，而不是上次连接成功的网关 Add by xjq, 2017-5-31 10:20:26
        if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUIYANG_EMM) {
            return 0;
        }

        MyApplication application = MyApplication.myApplication;
        if (application == null) {
            Log.e(TAG, "getPreferedGatewayIPIndex application == null.");
            return 0;
        }


        Integer index = (Integer)SharedPreferencesUtil.get(application, CONSTANT.PREFERED_GATEWAY_INDEX, 0);
        if (index == null) {
            return 0;
        }
        return index;

    }


    private void notifyNetworkTimeout() {
        MyApplication.myApplication.sendBroadcast(new Intent("com.xdja.safeclient.action.STOP_SERVICE"));
        Compatibility.showNetTimeoutDialog();
    }

    private void initAppAclType(int type) {
        appAclList.setAclType(type);
    }

    private void addAppAclRule(String packageName, String hash, String comment) {
        Log.d(TAG, "Package name " + packageName + " hash code " + hash + " comment " + comment);
        appAclList.getRuleList().add(new AppAclRule(packageName, hash, comment));
    }

    private void clearAppAclRule() {
        appAclList.getRuleList().clear();
    }

    static {
        System.loadLibrary("guardian");
        System.loadLibrary("safekey");
        System.loadLibrary("safetf");
        System.loadLibrary("xdjakeyserver");
        System.loadLibrary("sslvpn");

        System.loadLibrary("key_mgr");
        System.loadLibrary("key_zhongfu");
    }
}
