package com.xdja.sslvpn;

public class SafeClient {	
	/**
	 * 功能：启动安全客户端
	 * [in] String strDirPath 配置文件目录
	 * 返回值  0成功, 其它见“API返回码说明”
	 */
	public native int start(String strDirPath);
	
	/**
	 * 功能：获取当前状态
	 * [out] sslvpnStatus sslvpn状态对象
	 * 返回值 ：无
	 */
	public native int getStatus(SslvpnStatus sslvpnStatus);
	
	/**
	 *功能: 停止命令服务 
	 *返回值: 无
	 */
	public native int stop();
	
	/**
	 * 功能：安全口令认证 为获得某种操作角色的操作权，认证其对应的口令 
	 * [in] pass 口令最长16字节，不够右补0x06 
	 * [in] role 被认证口令的角色范围[0x01-0x05] 
	 * 返回值: 0成功, -2参数错误，其它见“API返回码说明”
	 */
	public native int SafePin(byte[] passwd, int role);
	
	/**
	 *功能：验证并修改PIN口令 
	 *[in] oldPasswd 旧口令最长16字节 
	 *[in] newPasswd 新口令最长16字节 
	 *[in] role 被修改口令对应的角色
	 *返回值: 0成功, -2参数错误，其它见“API返回码说明”
	 */
	public native int ModifyPin(byte[] oldPasswd,byte[] newPasswd, int role);
	
	static {
		System.loadLibrary("safekey");
		System.loadLibrary("safetf");
		System.loadLibrary("safeclient");
	}
}
