/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.device.DeviceManager;
import com.longmai.security.plugin.driver.Driver;
import com.longmai.security.plugin.driver.DriverManager;
import com.longmai.security.plugin.driver.ble.DeviceManagerImple;
import com.longmai.security.plugin.util.LogUtil;

public class BLEDriver
implements Driver {
    private static final String TAG = BLEDriver.class.getName();
    private static final int currentapiVersion = Build.VERSION.SDK_INT;
    private DeviceManager deviceManager;
    private Context context;

    static {
        try {
            DriverManager.registerDriver((Driver)new BLEDriver());
        }
        catch (Exception e) {
            throw new RuntimeException("Can't register driver!");
        }
        LogUtil.d((String)TAG, (String)"register driver");
    }

    public void init() throws PluginException {
        LogUtil.d((String)TAG, (String)"init()");
        throw new PluginException("Driver failed to initialize");
    }

    public void init(Object context) throws PluginException {
        LogUtil.d((String)TAG, (String)"init()");
        if (currentapiVersion < 18) {
            throw new PluginException(5);
        }
        if (context instanceof Context) {
            this.context = (Context)context;
            BluetoothManager bluetoothManager = (BluetoothManager)((Context)context).getSystemService("bluetooth");
            BluetoothAdapter mBluetoothAdapter = bluetoothManager.getAdapter();
            if (mBluetoothAdapter == null) {
                throw new PluginException(5);
            }
        } else {
            throw new PluginException("Driver failed to initialize");
        }
    }

    public DeviceManager getDeviceManager() throws PluginException {
        LogUtil.d((String)TAG, (String)"getDeviceManager()");
        if (this.deviceManager == null) {
            this.deviceManager = new DeviceManagerImple(this.context);
        }
        return this.deviceManager;
    }

    public void uninit() throws PluginException {
        LogUtil.d((String)TAG, (String)"uninit()");
        this.context = null;
        this.deviceManager = null;
        DriverManager.deregisterDriver((Driver)this);
    }
}

