/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.driver.ble.base.GattAttributesUUID;
import com.longmai.security.plugin.driver.ble.base.MessagePool;
import com.longmai.security.plugin.driver.ble.io.BLEInputStream;
import com.longmai.security.plugin.driver.ble.io.BLEOutputStream;
import com.longmai.security.plugin.driver.ble.io.stack.BleMessagePool;
import com.longmai.security.plugin.driver.conn.SecurityConnection;
import com.longmai.security.plugin.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class ConnectionImpl
extends BluetoothGattCallback
implements SecurityConnection {
    private static final String TAG = ConnectionImpl.class.getName();
    public static final int Client = 0;
    private BluetoothDevice device;
    private BluetoothGatt serverGatt;
    private BluetoothGattCharacteristic writeCharacteristic;
    private MessagePool messagePool = new BleMessagePool();
    private volatile int connState = 0;
    private volatile boolean isDiscoverServices = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionImpl(BluetoothDevice device) throws PluginException {
        List services;
        ConnectionImpl connectionImpl;
        this.device = device;
        BluetoothGatt gatt = device.connectGatt(null, false, (BluetoothGattCallback)this);
        if (gatt == null) {
            throw new PluginException(13);
        }
        this.serverGatt = gatt;
        if (this.connState != 2) {
            connectionImpl = this;
            synchronized (connectionImpl) {
                try {
                    LogUtil.w((String)TAG, (String)"ConnectionImpl.connectGatt.waiting()");
                    ((Object)((Object)this)).wait(10000L);
                    LogUtil.w((String)TAG, (String)"ConnectionImpl.connectGatt.waited()");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.connState != 2) {
            throw new PluginException(13);
        }
        this.isDiscoverServices = false;
        this.serverGatt.discoverServices();
        if (!this.isDiscoverServices) {
            connectionImpl = this;
            synchronized (connectionImpl) {
                try {
                    LogUtil.w((String)TAG, (String)"ConnectionImpl.discoverServices.waiting()");
                    ((Object)((Object)this)).wait(10000L);
                    LogUtil.w((String)TAG, (String)"ConnectionImpl.discoverServices.waited()");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((services = this.serverGatt.getServices()) == null) {
            LogUtil.w((String)TAG, (String)"getServices() Services is null");
            this.close();
            throw new PluginException(6);
        }
        HashMap<String, BluetoothGattCharacteristic> characteristicGroup = new HashMap<String, BluetoothGattCharacteristic>();
        for (BluetoothGattService service : services) {
            String serviceUUID = service.getUuid().toString();
            if (!serviceUUID.equals("0000fee9-0000-1000-8000-00805f9b34fb")) continue;
            List gattCharacteristics = service.getCharacteristics();
            if (gattCharacteristics == null || gattCharacteristics.size() == 0) {
                LogUtil.w((String)TAG, (String)"getCharacteristics() Characteristics is null");
                this.close();
                throw new PluginException(6);
            }
            for (BluetoothGattCharacteristic gattCharacteristic : gattCharacteristics) {
                characteristicGroup.put(gattCharacteristic.getUuid().toString(), gattCharacteristic);
            }
        }
        this.writeCharacteristic = (BluetoothGattCharacteristic)characteristicGroup.get("d44bc439-abfd-45a2-b575-925416129600");
        for (String notify_UUID : GattAttributesUUID.notifyAttributes) {
            BluetoothGattCharacteristic characteristic = (BluetoothGattCharacteristic)characteristicGroup.get(notify_UUID);
            if (characteristic == null) {
                LogUtil.w((String)TAG, (String)("No find Characteristic " + notify_UUID));
                this.close();
                throw new PluginException(6);
            }
            boolean flag = this.setCharacteristicNotification(characteristic, true);
            if (flag) continue;
            LogUtil.w((String)TAG, (String)("set Characteristic " + notify_UUID + " failure"));
            this.close();
            throw new PluginException(6);
        }
        try {
            this.messagePool.setWriteCharacteristic(this.serverGatt, this.writeCharacteristic);
            this.messagePool.write(new byte[]{1}, 0, 1, 255);
            byte[] apdu = this.messagePool.read();
            if (apdu[0] != 1) {
                this.close();
                throw new PluginException(6);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close();
            throw new PluginException(11);
        }
    }

    public InputStream getInputStream() throws PluginException {
        LogUtil.d((String)TAG, (String)"getInputStream()");
        return new BLEInputStream();
    }

    public OutputStream getOutputStream() throws PluginException {
        LogUtil.d((String)TAG, (String)"getOutputStream()");
        return new BLEOutputStream();
    }

    public boolean isValid() {
        LogUtil.d((String)TAG, (String)("isValid() - connState:" + this.connState));
        return this.connState == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws PluginException {
        LogUtil.d((String)TAG, (String)"close()");
        if (this.connState == 2) {
            this.serverGatt.disconnect();
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                int i = 0;
                while (i < 30) {
                    try {
                        LogUtil.w((String)TAG, (String)"ConnectionImpl.disconnect.waiting()");
                        ((Object)((Object)this)).wait(100L);
                        LogUtil.w((String)TAG, (String)"ConnectionImpl.disconnect.waited()");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.connState != 2) break;
                    ++i;
                }
            }
        }
    }

    public synchronized int deviceio(byte[] input, int input_len, byte[] output, int[] output_len, int protocol) throws PluginException {
        byte[] apdu;
        block6: {
            LogUtil.d((String)TAG, (String)"deviceio()");
            try {
                this.messagePool.write(input, 0, input_len, protocol);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PluginException(14);
            }
            try {
                apdu = this.messagePool.read();
                if (apdu != null) break block6;
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PluginException(15);
            }
        }
        if (output.length < apdu.length) {
            throw new PluginException(2);
        }
        System.arraycopy(apdu, 0, output, 0, apdu.length);
        output_len[0] = apdu.length;
        return 0;
    }

    public void setValue(int type, Object value) throws PluginException {
        LogUtil.d((String)TAG, (String)"setValue()");
    }

    public BluetoothDevice getValue(int type) throws PluginException {
        LogUtil.d((String)TAG, (String)("getValue() - type: " + type));
        if (type == 0) {
            return this.device;
        }
        return null;
    }

    public byte[] deriveSecurityCommSession(byte[] apdu) throws PluginException {
        LogUtil.d((String)TAG, (String)"deriveSecurityCommSession()");
        try {
            this.messagePool.write(apdu, 0, apdu.length, 240);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PluginException(14);
        }
        try {
            return this.messagePool.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PluginException(15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        LogUtil.w((String)TAG, (String)("onConnectionStateChange() - status:" + status + " newState:" + newState));
        this.connState = newState;
        switch (newState) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    this.messagePool.init();
                }
                catch (PluginException e) {
                    e.printStackTrace();
                }
                this.messagePool.setTimeOut(5000);
                ConnectionImpl e = this;
                synchronized (e) {
                    LogUtil.w((String)TAG, (String)"ConnectionImpl.connectGatt.notify()");
                    ((Object)((Object)this)).notify();
                    break;
                }
            }
            case 3: {
                break;
            }
            case 0: {
                if (this.serverGatt != null) {
                    this.serverGatt.close();
                }
                try {
                    this.messagePool.destroy();
                }
                catch (PluginException e) {
                    e.printStackTrace();
                }
                ConnectionImpl connectionImpl = this;
                synchronized (connectionImpl) {
                    LogUtil.w((String)TAG, (String)"ConnectionImpl.disconnect.notify()");
                    ((Object)((Object)this)).notify();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        LogUtil.d((String)TAG, (String)"onServicesDiscovered()");
        this.isDiscoverServices = true;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            LogUtil.w((String)TAG, (String)"ConnectionImpl.discoverServices.notify()");
            ((Object)((Object)this)).notify();
        }
    }

    public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
        long l = System.nanoTime();
        String uuid = UUID.randomUUID().toString();
        LogUtil.d((String)TAG, (String)("onCharacteristicChanged() - random: " + uuid));
        if (this.messagePool != null) {
            byte[] apdu = characteristic.getValue();
            try {
                this.messagePool.onReceive(apdu);
            }
            catch (IOException e) {
                LogUtil.e((String)TAG, (String)"onReceive() pool.write()", (Throwable)e);
            }
        } else {
            LogUtil.d((String)TAG, (String)"receive is null");
        }
        LogUtil.e((String)TAG, (String)("end - " + (System.nanoTime() - l) / 1000000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        LogUtil.d((String)TAG, (String)"onCharacteristicWrite()");
        MessagePool messagePool = this.messagePool;
        synchronized (messagePool) {
            LogUtil.w((String)TAG, (String)"BleMessagePool.write.notify()");
            this.messagePool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        LogUtil.d((String)TAG, (String)"onDescriptorWrite()");
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            LogUtil.w((String)TAG, (String)"ConnectionImpl.writeDescriptor.notify()");
            ((Object)((Object)this)).notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCharacteristicNotification(BluetoothGattCharacteristic characteristic, boolean enabled) {
        LogUtil.d((String)TAG, (String)"setCharacteristicNotification()");
        boolean flag = this.serverGatt.setCharacteristicNotification(characteristic, enabled);
        if (!flag) {
            return flag;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(UUID.fromString("00002902-0000-1000-8000-00805f9b34fb"));
        descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
        flag = this.serverGatt.writeDescriptor(descriptor);
        if (!flag) {
            return flag;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            try {
                LogUtil.w((String)TAG, (String)"ConnectionImpl.writeDescriptor.waiting()");
                ((Object)((Object)this)).wait();
                LogUtil.w((String)TAG, (String)"ConnectionImpl.writeDescriptor.waited()");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public int deviceio(byte[] input, int input_len, byte[] output, int[] output_len) throws PluginException {
        return this.deviceio(input, input_len, output, output_len, 128);
    }
}

