/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key.zhongfu;

import com.xdja.safeclient.utils.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ZhongfuDevState {
    private String THIS_FILE = "ZhongfuDevState";
    public static final int DEVICE_NOT_OPENED = 1000;
    public static final int APP_NOT_OPENED = 1001;
    public static final int CONTAINER_NOT_OPENED = 1002;
    private String devAdress;
    private long[] devHandle = new long[]{0L};
    private ArrayList<AppState> appStateArrayList = new ArrayList();

    public void init() {
        this.devAdress = null;
        for (AppState appState : this.appStateArrayList) {
            appState.init();
        }
        this.appStateArrayList.clear();
    }

    public int getDev(String device, long[] handle) {
        if (device.equalsIgnoreCase(this.devAdress)) {
            Log.d(this.THIS_FILE, "Device " + this.devAdress + " already opened.");
            handle[0] = this.devHandle[0];
            return 0;
        }
        return 1000;
    }

    public int getApp(String device, String appName, long[] appHandle) {
        if (!device.equalsIgnoreCase(this.devAdress)) {
            return 1000;
        }
        for (AppState appState : this.appStateArrayList) {
            if (!appName.equals(appState.appName)) continue;
            appHandle[0] = appState.appHandle[0];
            return 0;
        }
        return 1001;
    }

    public int getContainer(String device, String app, String container, long[] containerHandle) {
        if (!device.equalsIgnoreCase(this.devAdress)) {
            return 1000;
        }
        for (AppState appState : this.appStateArrayList) {
            if (!app.equals(appState.appName)) continue;
            for (Map.Entry<String, long[]> entry : appState.containers.entrySet()) {
                if (!container.equals(entry.getKey())) continue;
                long[] handle = entry.getValue();
                containerHandle[0] = handle[0];
                return 0;
            }
            return 1002;
        }
        return 1001;
    }

    public int updateDev(String device, long[] handle) {
        this.init();
        this.devAdress = device;
        this.devHandle[0] = handle[0];
        return 0;
    }

    public int updateApp(String device, String app, long[] handle) {
        if (!device.equalsIgnoreCase(this.devAdress)) {
            return 1000;
        }
        for (AppState appState : this.appStateArrayList) {
            if (!app.equals(appState.appName)) continue;
            if (appState.appHandle[0] == handle[0]) {
                Log.d(this.THIS_FILE, "Handle already update.");
                return 0;
            }
            appState.appHandle[0] = handle[0];
            appState.containers.clear();
            return 0;
        }
        AppState appState = new AppState();
        appState.appHandle[0] = handle[0];
        appState.appName = app;
        this.appStateArrayList.add(appState);
        return 0;
    }

    public int updateContainer(String device, String app, String container, long[] conHandle) {
        if (!device.equalsIgnoreCase(this.devAdress)) {
            return 1000;
        }
        for (AppState appState : this.appStateArrayList) {
            if (!app.equals(appState.appName)) continue;
            for (Map.Entry<String, long[]> entry : appState.containers.entrySet()) {
                if (!container.equals(entry.getKey())) continue;
                long[] handle = entry.getValue();
                handle[0] = conHandle[0];
                return 0;
            }
            appState.containers.put(container, conHandle);
            return 0;
        }
        return 1001;
    }

    private class AppState {
        String appName;
        long[] appHandle = new long[]{0L};
        HashMap<String, long[]> containers = new HashMap();

        private AppState() {
        }

        public void init() {
            this.appName = null;
            this.appHandle[0] = 0L;
            this.containers.clear();
        }
    }
}

