/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key.zhongfu;

import com.xdja.key.zhongfu.ZhongfuDevState;
import com.xdja.safeclient.utils.Log;
import com.zf.msmart.SmartCTCAPI;

public class ZhongfuWrapper {
    private static final String TAG = "ZhongfuWrapper";
    private static SmartCTCAPI smartapi = new SmartCTCAPI();
    private static ZhongfuWrapper key = null;
    ZhongfuDevState zhongfuDevState = new ZhongfuDevState();

    public static ZhongfuWrapper getInstance() {
        if (key == null) {
            key = new ZhongfuWrapper();
        }
        return key;
    }

    private ZhongfuWrapper() {
    }

    public long disconnect(String address) {
        Log.d(TAG, "Disconnect device");
        long[] devHandle = new long[1];
        long ret = this.zhongfuDevState.getDev(address, devHandle);
        if (ret == 0L) {
            ret = smartapi.SKF_DisConnectDev(devHandle[0]);
            if (ret == 0L) {
                Log.d(TAG, "Disconnect device success.");
                this.zhongfuDevState.init();
                return 0L;
            }
            Log.e(TAG, "Disconnect error. Ret " + ret);
        }
        Log.d(TAG, "Device " + address + " not opened.");
        return ret;
    }

    public long connect(String address, long[] devHandle) {
        long ret = this.zhongfuDevState.getDev(address, devHandle);
        if (ret == 0L) {
            Log.d(TAG, "Device " + address + " already opened.");
            return 0L;
        }
        ret = smartapi.SKF_ConnectDev(address.getBytes(), devHandle);
        if (ret == 0L) {
            this.zhongfuDevState.updateDev(address, devHandle);
        } else {
            Log.e(TAG, "Connect device " + address + " failed. ret " + ret);
        }
        return ret;
    }

    public long openApp(String device, String appName, long[] appHandle) {
        long[] devHandle = new long[1];
        long ret = this.zhongfuDevState.getApp(device, appName, appHandle);
        if (ret == 0L) {
            Log.d(TAG, "App " + appName + " already opened.");
            return 0L;
        }
        ret = this.connect(device, devHandle);
        if (ret != 0L) {
            Log.e(TAG, "Open device " + device + "failed.");
            return ret;
        }
        this.zhongfuDevState.getDev(device, devHandle);
        ret = smartapi.SKF_OpenApplication(devHandle[0], appName.getBytes(), appHandle);
        if (ret == 0L) {
            Log.d(TAG, "Open application success.");
            this.zhongfuDevState.updateApp(device, appName, appHandle);
        }
        return ret;
    }

    public long openContainer(String device, String appName, String container, long[] conHandle) {
        long[] devHandle = new long[1];
        long[] appHandle = new long[1];
        long ret = this.zhongfuDevState.getContainer(device, appName, container, conHandle);
        if (ret == 0L) {
            Log.d(TAG, "Container " + container + " already opened.");
            return ret;
        }
        ret = this.connect(device, devHandle);
        if (ret != 0L) {
            Log.e(TAG, "Open device " + device + "failed.");
            return ret;
        }
        ret = this.openApp(device, appName, appHandle);
        if (ret != 0L) {
            Log.e(TAG, "Open container " + container + "failed.");
            return ret;
        }
        ret = smartapi.SKF_OpenContainer(appHandle[0], container.getBytes(), conHandle);
        if (ret == 0L) {
            Log.d(TAG, "Open container " + container + " success.");
            this.zhongfuDevState.updateContainer(device, appName, container, conHandle);
        }
        return ret;
    }

    public long verifyPIN(long appHandle, String pin) {
        long[] pulRetryCount = new long[2];
        long ret = smartapi.SKF_VerifyPIN(appHandle, 1L, pin.getBytes(), pulRetryCount);
        if (ret != 0L) {
            Log.e(TAG, "Pin error. Have " + pulRetryCount[0] + " times retry");
        }
        return ret;
    }

    public long readCert(long conHandle, boolean isSign, byte[] cert, long[] len) {
        long ret = smartapi.SKF_ExportCertificate(conHandle, isSign, cert, len);
        if (ret != 0L) {
            Log.e(TAG, "Read cert error. ret " + ret);
            return ret;
        }
        return 0L;
    }

    public String getCardId(long devHandle) {
        SmartCTCAPI.DEVICEINFO devInfo = new SmartCTCAPI.DEVICEINFO();
        long ret = smartapi.SKF_GetDevInfo(devHandle, devInfo);
        if (ret != 0L) {
            Log.e(TAG, "Get dev info failed. ");
            return null;
        }
        return new String(devInfo.SerialNumber);
    }

    public long rsaSign(long containerHandle, byte[] inputData, long inputLen, byte[] outputData, long[] outputLen) {
        long ret = smartapi.SKF_RSASignData(containerHandle, inputData, inputLen, outputData, outputLen);
        if (ret != 0L) {
            Log.e(TAG, "RSA sign data error. ret " + ret);
        }
        return ret;
    }

    public long sm2Sign(long containerHandle, byte[] inputData, long inputLen, byte[] outputData, long[] outputLen) {
        SmartCTCAPI.ECCSIGNATUREBLOB sign = new SmartCTCAPI.ECCSIGNATUREBLOB();
        long ret = smartapi.SKF_ECCSignData(containerHandle, inputData, inputLen, sign);
        if (ret != 0L) {
            Log.e(TAG, "SM2 sign data error. ret " + ret);
        }
        System.arraycopy(sign.r, 0, outputData, 0, 32);
        System.arraycopy(sign.s, 0, outputData, 32, 32);
        outputLen[0] = 64L;
        return ret;
    }

    public long importCert(long conHandle, boolean isSign, byte[] certBuf, long certLen) {
        long ret = smartapi.SKF_ImportCertificate(conHandle, isSign, certBuf, certLen);
        if (ret != 0L) {
            Log.e(TAG, "Import cert faild. ret " + ret);
        } else {
            Log.d(TAG, "Import cert success.");
        }
        return ret;
    }
}

