/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient;

import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telephony.TelephonyManager;
import com.safetf.SafeTF;
import com.squareup.otto.Subscribe;
import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.datapersistence.DataPersistence;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.GuardianHelper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.VerifyTime;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.constant.IntentParam;
import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.ottoobj.StopVpnEvent;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.OttoUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.safeclient.utils.ToastUtil;
import com.xdja.sslvpn.SSLVPN;
import com.xdja.sslvpn.SocketListener;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class VpnService
extends Service {
    private static final String TAG = "VpnService";
    public static final int FORWARD_MODE = 0;
    public static final int TUNNEL_MODE = 1;
    public int connect = 0;
    public static SocketListener sock = null;
    public byte[] vpnstate = new byte[2048];
    public int vpnstatelen = 0;
    public static String issuccess = null;
    public String prestage = "";
    public static String curstage = "";
    public static boolean stopService = false;
    public static String errorState = "";
    private static String errorInfo = "";
    private static int errorInfoFlag = 0;
    private static NotificationManager nm = null;
    public static List<SafeVerifyStageInfo> sslStageList = new ArrayList<SafeVerifyStageInfo>();
    public static boolean safeVerifySuccess = false;
    public MyApplication myApplication = null;
    BroadcastReceiver sdcardBroadCastReceiver = null;
    private BroadcastReceiver screenBroadCastReceiver = null;
    private static boolean screenOn = true;
    public static boolean startflag = false;
    String serverIP = null;
    int serverPort = 0;
    byte[] gatewayIp = null;
    byte[] gatewayIp2 = null;
    byte[] gatewayIp3 = null;
    int gatewayPort = 0;
    String safePin = null;
    public static Object xlock = new Object();
    private Thread vpnSrvThread = null;
    public static int vpnSrvThreadStartFlag = 0;
    public static VpnService vpnObject = null;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    VpnService.this.showState();
                    break;
                }
                case 2: {
                    VpnService.this.vpnstatelen = msg.getData().getInt("len");
                    VpnService.this.vpnstate = msg.getData().getByteArray("content");
                    VpnService.this.showState();
                }
            }
        }
    };

    public IBinder onBind(Intent arg0) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        OttoUtil.register((Object)this);
        this.myApplication = (MyApplication)this.getApplication();
        Log.d("\u8ba4\u8bc1\u65f6\u95f4", "VPNService onCreate \u91cd\u7f6e\u8ba4\u8bc1\u6807\u8bc6");
        VerifyTime.writeVerifySuccess((Context)this, false);
        this.startWatchingDevice();
        this.startWatchingScreen();
        screenOn = true;
        vpnObject = this;
        this.myApplication.initDevState();
        if (this.myApplication.propertiesConfig != null && this.myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.getWakeLock();
        }
        errorInfoFlag = 0;
        errorInfo = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSDCardState(Context context, Intent intent) {
        Log.d(TAG, "getExternalStorageState : " + Environment.getExternalStorageState());
        if (!Function.getSafeVpnState(this.getApplicationContext())) {
            return;
        }
        safeVerifySuccess = false;
        errorState = StringUtil.getStringRes((Context)this, R.string.card_eject);
        SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
        stageInfo.name = StringUtil.getStringRes((Context)this, R.string.safe_verify);
        stageInfo.error = errorState;
        stageInfo.result = StringUtil.getStringRes((Context)this, R.string.fail);
        sslStageList.add(stageInfo);
        this.showVpnState(R.drawable.seq_off, this.getResources().getString(R.string.safe_client), errorState);
        if (0 == this.myApplication.sslClientConfig.transportMode) {
            if (this.myApplication.sslvpn != null) {
                this.myApplication.sslvpn.stopService();
                this.myApplication.sslvpn.release();
                this.myApplication.sslvpn = null;
                Object object = xlock;
                synchronized (object) {
                    if (sock != null) {
                        sock.close();
                        sock = null;
                    }
                }
            }
            Function.setSafeVpnState(this.getApplicationContext(), false);
            stopService = true;
        } else if (Compatibility.getAreaVersion() != 1000) {
            Object object = xlock;
            synchronized (object) {
                if (sock != null) {
                    sock.sendData("VPNEXIT");
                    sock.close();
                    Function.setSafeVpnState(this.getApplicationContext(), false);
                    stopService = true;
                    sock = null;
                }
            }
        }
        Compatibility.onSDCardEject();
        Log.d(TAG, "SDCard EJECT");
    }

    private void startWatchingScreen() {
        this.screenBroadCastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String[] pin = new String[2];
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                Log.d(VpnService.TAG, "screenBroadCastReceiver onReceive " + action);
                if ("android.intent.action.SCREEN_ON".equals(action)) {
                    if (VpnService.this.myApplication.sslvpn != null && VpnService.this.myApplication.sslClientConfig != null) {
                        Function.startVpnActivity(context);
                        screenOn = true;
                        VpnService.this.myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_ON.ordinal(), 0L);
                    }
                } else if ("android.intent.action.SCREEN_OFF".equals(action) && VpnService.this.myApplication.sslvpn != null) {
                    screenOn = false;
                    VpnService.this.myApplication.sslvpn.guardianLearn(GuardianHelper.guardian_option.G_OPT_SCREEN_OFF.ordinal(), 0L);
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.SCREEN_ON");
        this.registerReceiver(this.screenBroadCastReceiver, filter);
    }

    private void stopWatchingScreen() {
        if (this.screenBroadCastReceiver != null) {
            this.unregisterReceiver(this.screenBroadCastReceiver);
        }
    }

    private void startWatchingDevice() {
        this.sdcardBroadCastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                Log.d(VpnService.TAG, "onReceive " + action);
                Log.d(VpnService.TAG, "onReceive " + intent.getData());
                if (intent.getData().toString().contains("udisk")) {
                    Log.d(VpnService.TAG, "onReceive igore second sdcard eject");
                    return;
                }
                if ("android.intent.action.MEDIA_EJECT".equals(action)) {
                    VpnService.this.checkSDCardState(context, intent);
                }
            }
        };
        IntentFilter sdcardFilter = new IntentFilter();
        sdcardFilter.addAction("android.intent.action.MEDIA_EJECT");
        sdcardFilter.addDataScheme("file");
        this.registerReceiver(this.sdcardBroadCastReceiver, sdcardFilter);
    }

    private void stopWatchingDevice() {
        if (this.sdcardBroadCastReceiver != null) {
            this.unregisterReceiver(this.sdcardBroadCastReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        super.onDestroy();
        this.stopForeground(true);
        curstage = "";
        errorState = "";
        startflag = false;
        errorInfoFlag = 0;
        errorInfo = "";
        GuardianHelper.cancleOnceAlarm(this.getApplicationContext());
        Log.d(TAG, "middle onDestroy");
        if (this.myApplication.propertiesConfig != null && this.myApplication.propertiesConfig.getIsWakeLock() == 1) {
            Function.releaseWakeLock();
        }
        if (this.serverIP != null) {
            this.myApplication.sslClientConfig.setGateWayIp(this.gatewayIp);
            this.myApplication.sslClientConfig.setGateWayIp2(this.gatewayIp2);
            this.myApplication.sslClientConfig.setGateWayIp3(this.gatewayIp3);
            this.myApplication.sslClientConfig.setGateWayPort(this.gatewayPort);
        }
        if (0 == this.myApplication.sslClientConfig.transportMode) {
            if (this.myApplication.sslvpn != null) {
                this.myApplication.sslvpn.stopService();
                this.myApplication.sslvpn.release();
                this.myApplication.sslvpn = null;
                Object object = xlock;
                synchronized (object) {
                    if (sock != null) {
                        sock.close();
                        sock = null;
                    }
                }
            }
            Log.d(TAG, "onDestroy OK");
            Function.setSafeVpnState(this.getApplicationContext(), false);
            safeVerifySuccess = false;
        } else {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = xlock;
                    synchronized (object) {
                        if (sock != null) {
                            sock.sendData("VPNEXIT");
                            byte[] state = new byte[1024];
                            int statelen = sock.recvData(state);
                            if (statelen > 0) {
                                Log.d(VpnService.TAG, "state = " + new String(state, 0, statelen));
                            }
                            sock.close();
                            sock = null;
                        }
                    }
                    Function.setSafeVpnState(VpnService.this.getApplicationContext(), false);
                    safeVerifySuccess = false;
                }
            }).start();
        }
        this.stopWatchingDevice();
        this.stopWatchingScreen();
        if (this.myApplication.propertiesConfig.getmDisableFlag() == 1) {
            this.myApplication.disableFlag = 0;
        }
        if (nm != null) {
            nm.cancel(1);
        }
        VerifyTime.writeVerifySuccess((Context)this, false);
        Log.d("\u8ba4\u8bc1\u65f6\u95f4", "VPNService onDestroy \u91cd\u7f6e\u8ba4\u8bc1\u6807\u8bc6");
        stopService = true;
        OttoUtil.unRegister((Object)this);
    }

    public void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
        if (!Function.getSafeVpnState(this.getApplicationContext())) {
            this.serverIP = null;
            this.serverPort = 0;
            try {
                this.serverIP = intent.getStringExtra("ServerIP");
                this.serverPort = intent.getIntExtra("ServerPort", this.myApplication.sslClientConfig.gateWayPort);
                if (this.serverIP != null) {
                    Log.d(TAG, "serverIP = " + this.serverIP);
                    Log.d(TAG, "serverPort = " + this.serverPort);
                    this.gatewayIp = this.myApplication.sslClientConfig.getGateWayIp();
                    this.gatewayIp2 = this.myApplication.sslClientConfig.getGateWayIp2();
                    this.gatewayIp3 = this.myApplication.sslClientConfig.getGateWayIp3();
                    this.gatewayPort = this.myApplication.sslClientConfig.getGateWayPort();
                    this.myApplication.sslClientConfig.setGateWayIp(this.serverIP.getBytes());
                    this.myApplication.sslClientConfig.setGateWayIp2(this.serverIP.getBytes());
                    this.myApplication.sslClientConfig.setGateWayIp3(this.serverIP.getBytes());
                    this.myApplication.sslClientConfig.setGateWayPort(this.serverPort);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (intent != null) {
                this.safePin = null;
                this.safePin = intent.getStringExtra("SafePin");
                try {
                    if (this.safePin != null) {
                        Log.d(TAG, "putin safePin by intent, safePin = " + this.safePin);
                        this.myApplication.sslClientConfig.setPin(this.safePin.getBytes());
                        if (this.myApplication.propertiesConfig.getIgnoreLogin() != 0) {
                            SharedPreferences sharedPreferences = this.getSharedPreferences("SafeClientConfig", 0);
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putString("savepin", "true");
                            editor.commit();
                            String privatePath = this.getFilesDir().getPath();
                            DataPersistence dp = DataPersistence.getInstance((Context)this);
                            dp.addData("pin", this.safePin.getBytes());
                        }
                    } else {
                        Log.d(TAG, "not putin safePin by intent ");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            sslStageList.clear();
            if (SafeVerifyActivity.myAdapter != null) {
                SafeVerifyActivity.myAdapter.notifyDataSetChanged();
            }
            if (!Function.getSafeVpnState(this.getApplicationContext())) {
                sslStageList.clear();
                if (SafeVerifyActivity.myAdapter != null) {
                    SafeVerifyActivity.myAdapter.notifyDataSetChanged();
                }
            }
            Function.setSafeVpnState(this.getApplicationContext(), true);
            stopService = false;
            this.setRole();
            this.checkOtherSafeClient();
        }
    }

    private void setRole() {
        int role = this.myApplication.sslClientConfig.getRole();
        if (role != 1 && role != 17) {
            byte[] defaultCertId = this.myApplication.sslClientConfig.getCertId();
            role = Function.generateRole(defaultCertId);
            this.myApplication.sslClientConfig.setRole(role);
        }
    }

    private void checkOtherSafeClient() {
        if (Function.isServiceWork((Context)this, "com.xdja.safeclient.tun.video.TunVpnService")) {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getApplicationContext());
            builder.setTitle((CharSequence)StringUtil.getStringRes((Context)this, R.string.alert));
            builder.setMessage(this.getResources().getText(R.string.otherclientrunning));
            builder.setPositiveButton((CharSequence)StringUtil.getStringRes((Context)this, R.string.positive), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Function.stopOtherSafeClient(VpnService.this.getApplicationContext());
                    if (0 == VpnService.this.myApplication.sslClientConfig.transportMode) {
                        VpnService.this.startSslvpn();
                    }
                }
            });
            builder.setNegativeButton((CharSequence)StringUtil.getStringRes((Context)this, R.string.negative), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent itt = new Intent();
                    itt.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
                    VpnService.this.stopService(itt);
                    System.exit(0);
                }
            });
            AlertDialog dialog = builder.create();
            dialog.getWindow().setType(2003);
            dialog.show();
        } else if (0 == this.myApplication.sslClientConfig.transportMode) {
            this.startSslvpn();
        }
    }

    public String GetICCID(SafeTF tf, int hHandle) {
        String iccid = "";
        byte[] pDataOut = new byte[20];
        byte[] fid = new byte[]{0, 7};
        byte[] appid = new byte[]{9, 33};
        byte[] rootappid = new byte[]{63, 0};
        int nres = tf.SelectApp(hHandle, appid);
        if (nres != 0) {
            Log.d(TAG, "SelectApp,0x0921 failed");
            nres = tf.ReadCardBinFile(hHandle, fid, 0, 10, pDataOut);
        } else {
            nres = tf.ReadCardBinFile(hHandle, fid, 0, 10, pDataOut);
            nres = tf.SelectApp(hHandle, rootappid);
        }
        for (int i = 0; i < 10; ++i) {
            iccid = iccid + String.format("%02X", pDataOut[i]);
        }
        Log.d(TAG, "iccid = " + iccid);
        return iccid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String GetTerminalInfo(Context context, byte[] terminalInfo, int[] terminalInfoLen) {
        String strTermInfo = "";
        String cardSN = "";
        String iccid = "";
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        String imsi = "000000000000000";
        if (manager.getSimState() == 5) {
            imsi = manager.getSubscriberId();
        }
        String imei = manager.getDeviceId();
        try {
            if (0 == this.myApplication.sslClientConfig.getCertMode()) {
                byte[] cardId = new byte[64];
                int[] cardIdLen = new int[1];
                int ret = KeyWrapper.getInstance().getSN(cardId, cardIdLen);
                if (ret != 0) return KeyWrapper.StatusCode.getComment(ret);
                cardSN = new String(cardId, 0, cardIdLen[0]);
            } else {
                cardSN = "0000000000000000000000000000000000000000000000000000000000000000";
            }
            strTermInfo = "ANDROID;" + cardSN + ";" + imei + ";" + imsi + ";" + iccid;
            Log.d(TAG, "strTermInfo = " + strTermInfo);
            terminalInfoLen[0] = strTermInfo.getBytes().length;
            System.arraycopy(strTermInfo.getBytes(), 0, terminalInfo, 0, terminalInfoLen[0]);
            return "";
        }
        catch (Exception e) {
            Log.d(TAG, "Covercard failed." + e.getMessage());
            return StringUtil.getStringRes((Context)this, R.string.gen_terminal_info_failed);
        }
    }

    private boolean setGateWayIp() {
        if (this.myApplication.sslClientConfig == null) {
            Log.e(TAG, "myApplication.sslClientConfig == null");
            return false;
        }
        try {
            String gwip = new String(this.myApplication.sslClientConfig.getGateWayIp());
            Log.d(TAG, "gwip = " + gwip);
            if (!gwip.equals("")) {
                InetAddress inetAddress = InetAddress.getByName(gwip);
                if (inetAddress == null) {
                    Log.e(TAG, "get InetAddress By Name failed");
                } else {
                    Log.d(TAG, "GateWayIp = " + inetAddress.getHostAddress());
                    this.myApplication.sslClientConfig.setGateWayIp(inetAddress.getHostAddress().getBytes());
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e(TAG, "get GateWayIp By Name failed");
        }
        try {
            String gwip2 = new String(this.myApplication.sslClientConfig.getGateWayIp2());
            Log.d(TAG, "gwip2 = " + gwip2);
            if (!gwip2.equals("")) {
                InetAddress inetAddress2 = InetAddress.getByName(gwip2);
                if (inetAddress2 == null) {
                    Log.e(TAG, "get InetAddress2 By Name failed");
                } else {
                    Log.d(TAG, "GateWayIp2 = " + inetAddress2.getHostAddress());
                    this.myApplication.sslClientConfig.setGateWayIp2(inetAddress2.getHostAddress().getBytes());
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e(TAG, "get GateWayIp2 By Name failed");
        }
        try {
            String gwip3 = new String(this.myApplication.sslClientConfig.getGateWayIp3());
            Log.d(TAG, "gwip3 = " + gwip3);
            if (!gwip3.equals("")) {
                InetAddress inetAddress3 = InetAddress.getByName(gwip3);
                if (inetAddress3 == null) {
                    Log.e(TAG, "get InetAddress3 By Name failed");
                } else {
                    Log.d(TAG, "GateWayIp3 = " + inetAddress3.getHostAddress());
                    this.myApplication.sslClientConfig.setGateWayIp3(inetAddress3.getHostAddress().getBytes());
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            Log.e(TAG, "get GateWayIp2 By Name failed");
            return false;
        }
        return true;
    }

    public void startSslvpn() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                int nres = -1;
                Looper.prepare();
                if (VpnService.this.myApplication.propertiesConfig.getIsBigThan4G() != 0 && !Function.isSDTotalSizeBigThan4G(Function.getSDTotalSize(VpnService.this.myApplication.getApplicationContext()))) {
                    errorState = StringUtil.getStringRes((Context)VpnService.this, R.string.safe_card_version_unmatched);
                    VpnService.this.showVpnState(R.drawable.seq_off, VpnService.this.getResources().getString(R.string.safe_client), errorState);
                    Function.setSafeVpnState(VpnService.this.getApplicationContext(), false);
                    safeVerifySuccess = false;
                    stopService = true;
                    return;
                }
                byte[] terminalInfo = new byte[256];
                int[] terminalInfoLen = new int[]{0};
                String strRes = VpnService.this.GetTerminalInfo(VpnService.this.myApplication.getApplicationContext(), terminalInfo, terminalInfoLen);
                if (!strRes.equals("")) {
                    errorState = strRes;
                    VpnService.this.showVpnState(R.drawable.seq_off, VpnService.this.getResources().getString(R.string.safe_client), errorState);
                    Function.setSafeVpnState(VpnService.this.getApplicationContext(), false);
                    safeVerifySuccess = false;
                    stopService = true;
                    return;
                }
                if (VpnService.this.myApplication.sslvpn != null) {
                    VpnService.this.myApplication.sslvpn.stopService();
                    VpnService.this.myApplication.sslvpn.release();
                    VpnService.this.myApplication.sslvpn = null;
                }
                VpnService.this.myApplication.sslvpn = new SSLVPN();
                VpnService.this.myApplication.sslClientConfig.setTerminalInfo(terminalInfo);
                VpnService.this.myApplication.sslClientConfig.setNetType(GuardianHelper.getNetWorkType(VpnService.this.myApplication.getApplicationContext()).ordinal());
                VpnService.this.setGateWayIp();
                Log.d(VpnService.TAG, "" + new String(VpnService.this.myApplication.sslClientConfig.getDevPath()));
                nres = VpnService.this.myApplication.sslvpn.setParam(VpnService.this.myApplication.sslClientConfig);
                if (nres != 0) {
                    errorState = nres == -1134 ? StringUtil.getStringRes((Context)VpnService.this, R.string.no_cert) : StringUtil.getStringRes((Context)VpnService.this, R.string.invalid_param);
                    VpnService.this.showVpnState(R.drawable.seq_off, VpnService.this.getResources().getString(R.string.safe_client), errorState);
                    Function.setSafeVpnState(VpnService.this.getApplicationContext(), false);
                    safeVerifySuccess = false;
                    stopService = true;
                    return;
                }
                startflag = true;
                int connectRet = 0;
                Object object2 = xlock;
                synchronized (object2) {
                    if (sock == null) {
                        sock = new SocketListener("127.0.0.1", VpnService.this.myApplication.sslClientConfig.getPrivatePort());
                    }
                    if (sock != null) {
                        Log.d(VpnService.TAG, "check cmd port");
                        connectRet = sock.connect();
                    }
                }
                if (connectRet == 0) {
                    Log.d(VpnService.TAG, "cmd port already bind, service alread started");
                } else if (VpnService.this.myApplication.sslvpn != null && (nres = VpnService.this.myApplication.sslvpn.startService()) != 0) {
                    errorState = StringUtil.getStringRes((Context)VpnService.this, R.string.start_service_failed);
                    VpnService.this.showVpnState(R.drawable.seq_off, VpnService.this.getResources().getString(R.string.safe_client), StringUtil.getStringRes((Context)VpnService.this, R.string.start_service_failed));
                    Function.setSafeVpnState(VpnService.this.getApplicationContext(), false);
                    safeVerifySuccess = false;
                    stopService = true;
                    return;
                }
                vpnSrvThreadStartFlag = 1;
                object2 = xlock;
                synchronized (object2) {
                    if (sock == null) {
                        sock = new SocketListener("127.0.0.1", VpnService.this.myApplication.sslClientConfig.getPrivatePort());
                    }
                    if (sock != null) {
                        nres = connectRet != 0 ? sock.connect() : connectRet;
                    }
                }
                long ctime = System.currentTimeMillis();
                while (nres != 0) {
                    if (System.currentTimeMillis() - ctime > 3000L) {
                        Log.e(VpnService.TAG, "connect to 127.0.0.1:" + VpnService.this.myApplication.sslClientConfig.getPrivatePort() + " failed");
                        errorState = StringUtil.getStringRes((Context)VpnService.this, R.string.connect_service_failed);
                        VpnService.this.showVpnState(R.drawable.seq_off, VpnService.this.getResources().getString(R.string.safe_client), StringUtil.getStringRes((Context)VpnService.this, R.string.connect_service_failed));
                        object = xlock;
                        synchronized (object) {
                            if (sock != null) {
                                sock.close();
                                sock = null;
                            }
                        }
                        VpnService.this.myApplication.sslvpn.stopService();
                        Function.setSafeVpnState(VpnService.this.getApplicationContext(), false);
                        safeVerifySuccess = false;
                        stopService = true;
                        return;
                    }
                    object = xlock;
                    synchronized (object) {
                        if (sock != null) {
                            nres = sock.connect();
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
                object = xlock;
                synchronized (object) {
                    if (sock != null) {
                        sock.sendData("VPNSTART");
                        VpnService.this.vpnstatelen = sock.recvData(VpnService.this.vpnstate);
                    }
                }
                if (!Function.getSafeVpnState(VpnService.this.getApplicationContext())) {
                    stopService = true;
                    SafeVerifyActivity.startService = false;
                    vpnSrvThreadStartFlag = 0;
                }
                object = xlock;
                synchronized (object) {
                    if (sock == null) {
                        stopService = true;
                        SafeVerifyActivity.startService = false;
                        vpnSrvThreadStartFlag = 0;
                    }
                }
                if (VpnService.this.vpnstatelen > 0) {
                    // empty if block
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execRootCmdSilent(String cmd) {
        int result = -1;
        FilterOutputStream dos = null;
        String strSuTool = null;
        if (this.myApplication.propertiesConfig.getmSuOrXdsu() == 0) {
            strSuTool = "su";
            Log.i(TAG, "su");
        } else {
            strSuTool = "xdsu xdja";
            Log.i(TAG, "xdsu xdja");
        }
        try {
            Process p = Runtime.getRuntime().exec(strSuTool);
            dos = new DataOutputStream(p.getOutputStream());
            ((DataOutputStream)dos).writeBytes(cmd + "\n");
            ((DataOutputStream)dos).flush();
            ((DataOutputStream)dos).writeBytes("exit\n");
            ((DataOutputStream)dos).flush();
            p.waitFor();
            result = p.exitValue();
            Log.i(TAG, cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public void stateChange(byte[] state, int len) {
        Log.v(TAG, "++++++++++++");
        Message message = new Message();
        message.what = 2;
        Bundle bundle = new Bundle();
        bundle.putInt("len", len);
        bundle.putByteArray("content", state);
        message.setData(bundle);
        this.mHandler.sendMessage(message);
    }

    private void saveCertifyTime(String data) {
        if (this.myApplication.sslvpn == null) {
            Log.d("VerifyTime", "sslvpn is null");
            return;
        }
        String[] state = data.split(" ");
        String success = state[0];
        String stage = state[1];
        if (!success.equals("OK")) {
            VerifyTime.writeVerifySuccess((Context)this, false);
        }
        if (success.equals("OK") && stage.equals("100") && !VerifyTime.readLastVerifySuccess((Context)this)) {
            VerifyTime.writeVerifyTime((Context)this);
            VerifyTime.writeVerifySuccess((Context)this, true);
        }
    }

    public void showState() {
        this.saveCertifyTime(new String(this.vpnstate, 0, this.vpnstatelen));
        if (this.vpnstatelen < 0) {
            Log.d(TAG, "vpnstatelen = " + this.vpnstatelen);
            return;
        }
        if (!screenOn) {
            // empty if block
        }
        if (!startflag) {
            Log.d(TAG, "service stop, give up status show");
            return;
        }
        int firstindex = 0;
        int lastindex = 0;
        String stageStatus = "";
        String errorStatus = "";
        String errorCode = "";
        String temp = null;
        temp = new String(this.vpnstate, 0, this.vpnstatelen);
        try {
            String[] arrState = temp.split(" ");
            issuccess = arrState[0];
            curstage = arrState[1];
            errorCode = arrState[2];
            if (Integer.parseInt(errorCode) == -1510) {
                errorStatus = arrState[3];
                errorInfoFlag = !errorInfo.equals(errorStatus) ? 1 : 0;
                errorInfo = errorStatus;
                Log.d(TAG, "errorInfo: " + errorInfo);
            } else {
                lastindex = StringUtil.getCharacterPosition(temp, " ", 3);
                errorStatus = new String(this.vpnstate, lastindex + 1, this.vpnstatelen - lastindex - 1, "gbk");
            }
        }
        catch (Exception e) {
            Log.d(TAG, "vpnstate :" + temp + " len :" + temp.length());
            Log.d(TAG, "firstindex: " + firstindex);
            Log.d(TAG, "lastindex: " + lastindex);
            return;
        }
        if (curstage.compareTo(this.prestage) != 0 || errorInfoFlag == 1) {
            this.prestage = curstage;
            SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
            if (curstage.compareTo("20") == 0) {
                stageInfo.name = this.getString(R.string.init_safe_component);
            } else if (curstage.compareTo("30") == 0) {
                stageInfo.name = this.getString(R.string.connect_to_safe_gateway);
            } else if (curstage.compareTo("40") == 0) {
                stageInfo.name = StringUtil.getStringRes((Context)this, R.string.safe_verify);
            } else if (curstage.compareTo("50") == 0) {
                stageInfo.name = this.getString(R.string.bind_verify_info);
            } else if (curstage.compareTo("60") == 0) {
                stageInfo.name = this.getString(R.string.start_service);
            } else if (curstage.compareTo("100") == 0) {
                stageInfo.name = this.myApplication.sslClientConfig.transportMode == 0 ? this.getString(R.string.safe_tunnel_via_trans_mode) : this.getString(R.string.safe_tunnel_via_tunnel_mode);
            } else {
                return;
            }
            if (issuccess.compareTo("OK") == 0) {
                stageInfo.result = StringUtil.getStringRes((Context)this, R.string.success);
                stageStatus = stageInfo.name + stageInfo.result;
            } else {
                stageInfo.result = StringUtil.getStringRes((Context)this, R.string.fail);
            }
            stageInfo.error = errorStatus;
            sslStageList.add(stageInfo);
            if (SafeVerifyActivity.myAdapter != null) {
                SafeVerifyActivity.myAdapter.notifyDataSetChanged();
            }
            if (issuccess.compareTo("OK") == 0) {
                if (curstage.compareTo("100") == 0) {
                    errorInfoFlag = 0;
                    errorInfo = "";
                    if (nm != null) {
                        nm.cancel(1);
                    }
                    safeVerifySuccess = true;
                    errorState = "";
                    this.showVpnState(R.drawable.seq_on, this.getResources().getString(R.string.safe_client), stageStatus);
                    if (this.myApplication.sslClientConfig.transportMode != 0) {
                        String ifconfig = "/data/data/com.xdja.safeclient/files/ifconfig.sh";
                        try {
                            this.execRootCmdSilent("chmod 771 " + ifconfig);
                            this.execRootCmdSilent(ifconfig);
                        }
                        catch (Exception e) {
                            Log.d(TAG, "execRootCmdSilent " + ifconfig + " failed");
                            e.printStackTrace();
                            return;
                        }
                    } else if (Build.VERSION.SDK_INT >= 10) {
                        SCAutoUpdate.updateStart((Context)this, false);
                    }
                } else {
                    ++this.connect;
                    if (this.connect > 4) {
                        this.connect = 1;
                    }
                    switch (this.connect) {
                        case 1: {
                            this.showVpnState(R.drawable.seq_conn1, this.getResources().getString(R.string.safe_client), stageStatus);
                            break;
                        }
                        case 2: {
                            this.showVpnState(R.drawable.seq_conn2, this.getResources().getString(R.string.safe_client), stageStatus);
                            break;
                        }
                        case 3: {
                            this.showVpnState(R.drawable.seq_conn3, this.getResources().getString(R.string.safe_client), stageStatus);
                            break;
                        }
                        case 4: {
                            this.showVpnState(R.drawable.seq_conn4, this.getResources().getString(R.string.safe_client), stageStatus);
                        }
                    }
                }
            } else {
                Log.d(TAG, "curstage: " + curstage);
                Log.d(TAG, "issuccess: " + issuccess);
                Log.d(TAG, "errorStatus: " + errorStatus);
                safeVerifySuccess = false;
                errorState = errorStatus;
                this.showVpnState(R.drawable.seq_off, this.getResources().getString(R.string.safe_client), errorStatus);
                if (errorInfoFlag == 1) {
                    this.showVpnErrorInfo(R.drawable.tf_locked, this.getResources().getString(R.string.safe_client), errorInfo);
                }
            }
        }
    }

    public void showVpnState(int icon, String title, String text) {
        if (this.myApplication.propertiesConfig.getNotification() == 0) {
            Intent intent = new Intent((Context)this, SafeVerifyActivity.class);
            intent.putExtra("FLAG_START_FROM_NOTIFICATION", true);
            Notification.Builder builder = new Notification.Builder((Context)this);
            builder.setSmallIcon(icon);
            builder.setWhen(System.currentTimeMillis());
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0);
            builder.setContentIntent(pendingIntent);
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)text);
            this.startForeground(2, builder.build());
        }
    }

    private void showVpnErrorInfo(int icon, String title, String text) {
        nm = (NotificationManager)this.getSystemService("notification");
        Notification.Builder builder = new Notification.Builder((Context)this);
        builder.setSmallIcon(icon);
        builder.setWhen(System.currentTimeMillis());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, SafeVerifyActivity.class), (int)0);
        builder.setContentIntent(pendingIntent);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)text);
        nm.notify(1, builder.build());
    }

    @Subscribe
    public void handleExitAppEvent(ExitAppEvent event) {
        this.handleStopVpnServiceEvent(new StopVpnEvent());
    }

    @Subscribe
    public void handleStopVpnServiceEvent(StopVpnEvent event) {
        boolean success = this.stopService(IntentParam.stopTunVpn((Context)this));
        if (success) {
            Function.setSafeVpnState(this.getApplicationContext(), false);
            stopService = true;
            sslStageList.clear();
        } else {
            ToastUtil.show((Context)this, R.string.stop_service_failed);
        }
    }
}

