/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.config.UpgradeConfig;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.StringUtil;

public class ConnectSetActivity
extends BaseActivity {
    public EditText et_gatewayIp = null;
    public EditText et_gatewayIp2 = null;
    public EditText et_gatewayIp3 = null;
    public EditText et_gatewayPort = null;
    public EditText et_upgradeIp = null;
    public EditText et_upgradePort = null;
    public EditText et_connectTimeout = null;
    public EditText et_retryconnectCount = null;
    public MyApplication myApplication = null;
    public SslClientConfig sslClientConfig = null;
    public UpgradeConfig upgradeConfig = null;
    private String[] TransModeStr;
    private int iTransMode = 0;
    private Spinner spinnerTransMode = null;
    private String[] CertTypeStr = null;
    private int iCertType = 0;
    private Spinner spinnerCertType = null;
    private String mPropertiesPath = null;
    private LinearLayout mTransModeLinearLayout = null;
    private LinearLayout mCertTypeLinnearLayout = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connectset);
        this.TransModeStr = new String[]{StringUtil.getStringRes((Context)this, R.string.mode_trans), StringUtil.getStringRes((Context)this, R.string.mode_tunnel)};
        this.CertTypeStr = new String[]{StringUtil.getStringRes((Context)this, R.string.exchange_cert), StringUtil.getStringRes((Context)this, R.string.sign_cert)};
        this.et_gatewayIp = (EditText)this.findViewById(R.id.et_gw_ip1);
        this.et_gatewayIp2 = (EditText)this.findViewById(R.id.et_gw_ip2);
        this.et_gatewayIp3 = (EditText)this.findViewById(R.id.et_gw_ip_3);
        this.et_gatewayPort = (EditText)this.findViewById(R.id.et_gw_port);
        this.et_upgradeIp = (EditText)this.findViewById(R.id.et_upgrade_ip);
        this.et_upgradePort = (EditText)this.findViewById(R.id.et_upgrade_port);
        this.et_connectTimeout = (EditText)this.findViewById(R.id.et_connect_timeout);
        this.et_retryconnectCount = (EditText)this.findViewById(R.id.et_retry_count);
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mRightBtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.mTransModeLinearLayout = (LinearLayout)this.findViewById(R.id.ll_trans_mode);
        this.mCertTypeLinnearLayout = (LinearLayout)this.findViewById(R.id.certtype_linearlayout);
        this.initLeftBtn();
        this.initTitleText();
        this.initRightBtn();
        this.myApplication = (MyApplication)this.getApplication();
        this.myApplication.readSslclientConfigFile();
        this.sslClientConfig = this.myApplication.sslClientConfig;
        this.upgradeConfig = this.myApplication.upgradeConfig;
        String gatewayIp = new String(this.sslClientConfig.getGateWayIp());
        String gatewayIp2 = "";
        gatewayIp2 = this.sslClientConfig.getGateWayIp2() == null || this.sslClientConfig.getGateWayIp2().equals("") ? "" : new String(this.sslClientConfig.getGateWayIp2());
        String gatewayIp3 = "";
        gatewayIp3 = this.sslClientConfig.getGateWayIp3() == null || this.sslClientConfig.getGateWayIp3().equals("") ? "" : new String(this.sslClientConfig.getGateWayIp3());
        String gatewayPort = Integer.toString(this.sslClientConfig.gateWayPort);
        String connectTimeout = Integer.toString(this.sslClientConfig.connectTimeOut);
        String retryconnectCount = Integer.toString(this.sslClientConfig.retryConnectCount);
        String upgradeIp = this.upgradeConfig.getServerIp();
        String upgradePort = this.upgradeConfig.getServerPort();
        this.et_gatewayIp.setText((CharSequence)gatewayIp);
        this.et_gatewayIp2.setText((CharSequence)gatewayIp2);
        this.et_gatewayIp3.setText((CharSequence)gatewayIp3);
        this.et_gatewayPort.setText((CharSequence)gatewayPort);
        this.et_connectTimeout.setText((CharSequence)connectTimeout);
        this.et_retryconnectCount.setText((CharSequence)retryconnectCount);
        this.et_upgradeIp.setText((CharSequence)upgradeIp);
        this.et_upgradePort.setText((CharSequence)upgradePort);
        this.mPropertiesPath = this.getFilesDir().getAbsolutePath() + "/conf.properties";
        this.initSpiner(this.spinnerTransMode, R.id.transport_mode_spinner, this.TransModeStr);
        this.initSpiner(this.spinnerCertType, R.id.cert_type_spinner, this.CertTypeStr);
        if (this.myApplication.propertiesConfig.getmShowTransportModeSet() == 0) {
            this.mTransModeLinearLayout.setVisibility(8);
        } else {
            this.mTransModeLinearLayout.setVisibility(0);
        }
        if (this.myApplication.propertiesConfig.getmShowCertTypeSet() == 0) {
            this.mCertTypeLinnearLayout.setVisibility(8);
        } else {
            this.mCertTypeLinnearLayout.setVisibility(0);
        }
    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        this.mTitleText.setText(R.string.connectset);
    }

    @Override
    protected void initRightBtn() {
        super.initRightBtn();
        this.mRightBtn.setVisibility(0);
        this.mRightBtn.setBackgroundResource(R.drawable.save);
        this.mRightBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConnectSetActivity.this.save();
            }
        });
    }

    private Spinner initSpiner(Spinner spinner, int id2, String[] strArray) {
        ArrayAdapter adapter = null;
        spinner = (Spinner)this.findViewById(id2);
        adapter = new ArrayAdapter((Context)this, R.layout.spinner_item_select, (Object[])strArray);
        adapter.setDropDownViewResource(R.layout.spinner_item_dropdown);
        spinner.setAdapter((SpinnerAdapter)adapter);
        if (R.id.transport_mode_spinner == id2) {
            Log.d("ConnectSetActivity", "init transport_mode_spinner " + strArray[this.sslClientConfig.getTransportMode()]);
            this.iTransMode = this.sslClientConfig.getTransportMode();
            spinner.setSelection(this.iTransMode);
        } else if (R.id.cert_type_spinner == id2) {
            this.iCertType = this.myApplication.propertiesConfig.getmCertType();
            Log.d("ConnectSetActivity", "loadProperties, iCertType = " + this.iCertType);
            spinner.setSelection(this.iCertType);
        }
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> arg0, View v, int position, long arg3) {
                int id2 = arg0.getId();
                if (R.id.transport_mode_spinner == id2) {
                    Log.d("ConnectSetActivity", "transport_mode_spinner checked " + arg0.getItemAtPosition(position).toString());
                    ConnectSetActivity.this.iTransMode = position;
                    if (ConnectSetActivity.this.iTransMode == 1) {
                        Toast.makeText((Context)arg0.getContext(), (CharSequence)StringUtil.getStringRes((Context)ConnectSetActivity.this, R.string.tunnel_mode_failed_cz_version_unmatched), (int)0).show();
                    }
                } else if (R.id.cert_type_spinner == id2) {
                    ConnectSetActivity.this.iCertType = position;
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
        return spinner;
    }

    public void save() {
        String gatewayIp = this.et_gatewayIp.getText().toString();
        String gatewayIp2 = this.et_gatewayIp2.getText().toString();
        String gatewayIp3 = this.et_gatewayIp3.getText().toString();
        String gatewayPort = this.et_gatewayPort.getText().toString();
        String upgradeIp = this.et_upgradeIp.getText().toString();
        String upgradePort = this.et_upgradePort.getText().toString();
        String connectTimeout = this.et_connectTimeout.getText().toString();
        String retryconnectCount = this.et_retryconnectCount.getText().toString();
        if (gatewayIp == null || gatewayIp.equals("")) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.gateway1_empty), (int)0).show();
            return;
        }
        if (!this.checkIP(gatewayIp)) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.gateway1_format_error), (int)0).show();
            return;
        }
        if (gatewayIp2 != null && !gatewayIp2.equals("") && !this.checkIP(gatewayIp2)) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.gateway2_format_error), (int)0).show();
            return;
        }
        if (gatewayIp3 != null && !gatewayIp3.equals("") && !this.checkIP(gatewayIp3)) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.gateway3_format_error), (int)0).show();
            return;
        }
        if (gatewayPort == null || gatewayPort.equals("")) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.gateway_port_empty), (int)0).show();
            return;
        }
        if (!this.checkPort(Integer.parseInt(gatewayPort))) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.gateway_port_format_error), (int)0).show();
            return;
        }
        if (upgradeIp == null || upgradeIp.equals("")) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.update_server_address_empty), (int)0).show();
            return;
        }
        if (upgradePort == null || upgradePort.equals("")) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.update_server_port_empty), (int)0).show();
            return;
        }
        if (!this.checkPort(Integer.parseInt(upgradePort))) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.update_server_port_format_error), (int)0).show();
            return;
        }
        if (connectTimeout == null || connectTimeout.equals("")) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.connect_timeout_empty), (int)0).show();
            return;
        }
        if (retryconnectCount == null || retryconnectCount.equals("")) {
            Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.reconnect_count_empty), (int)0).show();
            return;
        }
        this.sslClientConfig.setGateWayIp(gatewayIp.getBytes());
        this.sslClientConfig.setGateWayIp2(gatewayIp2.getBytes());
        this.sslClientConfig.setGateWayIp3(gatewayIp3.getBytes());
        this.sslClientConfig.setGateWayPort(Integer.parseInt(gatewayPort));
        this.sslClientConfig.setConnectTimeOut(Integer.parseInt(connectTimeout));
        this.sslClientConfig.setRetryConnectCount(Integer.parseInt(retryconnectCount));
        this.sslClientConfig.setTransportMode(this.iTransMode);
        this.myApplication.writeSslclientConfigFile();
        this.myApplication.propertiesConfig.setmCertType(this.iCertType);
        this.myApplication.propertiesConfig.savePropertiesConfig(this.mPropertiesPath);
        this.upgradeConfig.setServerIp(upgradeIp);
        this.upgradeConfig.setServerPort(upgradePort);
        this.myApplication.writeUpgradeConfigFile();
        Toast.makeText((Context)this, (CharSequence)StringUtil.getStringRes((Context)this, R.string.save_success), (int)0).show();
        this.finish();
    }

    public boolean checkIP(String strIP) {
        String regex = "((?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d))))";
        return strIP.matches(regex);
    }

    public boolean checkPort(int port) {
        return 1 <= port && port <= 65535;
    }
}

