/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.sslvpn.SslvpnStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;

public class CurrentStatusActivity
extends BaseActivity {
    TextView tv_transportMode = null;
    TextView tv_listenPortText = null;
    TextView tv_listenPort = null;
    TextView tv_recvDataPackage = null;
    TextView tv_sendDataPackage = null;
    TextView tv_serviceStarttime = null;
    TextView tv_breaklineRetryconnectCount = null;
    TextView tv_netDelay = null;
    TextView tv_name = null;
    TextView tv_dep = null;
    TextView tv_nameText = null;
    TextView tv_depText = null;
    public byte[] vpncurstate = new byte[4096];
    private String TAG = "CurrentStatusActivity";
    public static SslvpnStatus sslvpnStatus = new SslvpnStatus();
    private MyApplication myApplication = null;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    CurrentStatusActivity.this.setPage();
                    break;
                }
                case 2: {
                    String result = (String)msg.obj;
                    CurrentStatusActivity.this.setNameAndDepartment(result);
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_current_status);
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.mTitleText.setText((CharSequence)this.getString(R.string.currentstatus));
        this.initLeftBtn();
        this.tv_transportMode = (TextView)this.findViewById(R.id.transportmode);
        this.tv_listenPortText = (TextView)this.findViewById(R.id.listenporttext);
        this.tv_listenPort = (TextView)this.findViewById(R.id.listenport);
        this.tv_recvDataPackage = (TextView)this.findViewById(R.id.recvdatapackage);
        this.tv_sendDataPackage = (TextView)this.findViewById(R.id.senddatapackage);
        this.tv_serviceStarttime = (TextView)this.findViewById(R.id.serverstarttime);
        this.tv_breaklineRetryconnectCount = (TextView)this.findViewById(R.id.breaklineretryconnectcount);
        this.tv_netDelay = (TextView)this.findViewById(R.id.netdelay);
        this.tv_name = (TextView)this.findViewById(R.id.person_name);
        this.tv_dep = (TextView)this.findViewById(R.id.person_dep);
        this.tv_nameText = (TextView)this.findViewById(R.id.person_name_text);
        this.tv_depText = (TextView)this.findViewById(R.id.person_dep_text);
        if (!Compatibility.showPersionInfo()) {
            this.tv_name.setVisibility(8);
            this.tv_dep.setVisibility(8);
            this.tv_nameText.setVisibility(8);
            this.tv_depText.setVisibility(8);
        }
        this.myApplication = (MyApplication)this.getApplication();
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
        if (0 == this.myApplication.sslClientConfig.transportMode) {
            SslvpnStatus sslvpnStatus = new SslvpnStatus();
            this.myApplication.sslvpn.getStatus(sslvpnStatus);
            this.tv_transportMode.setText((CharSequence)StringUtil.getStringRes((Context)this, R.string.mode_trans));
            this.tv_listenPortText.setText(R.string.listenport);
            this.tv_listenPort.setText((CharSequence)sslvpnStatus.listenPortList);
            this.tv_recvDataPackage.setText((CharSequence)(sslvpnStatus.recvDataSize + "KB"));
            this.tv_sendDataPackage.setText((CharSequence)(sslvpnStatus.sendDataSize + "KB"));
            if (sslvpnStatus.dataServerStartTime < 60) {
                this.tv_serviceStarttime.setText((CharSequence)(sslvpnStatus.dataServerStartTime + StringUtil.getStringRes((Context)this, R.string.second)));
            } else {
                this.tv_serviceStarttime.setText((CharSequence)(sslvpnStatus.dataServerStartTime / 60 + StringUtil.getStringRes((Context)this, R.string.minute) + sslvpnStatus.dataServerStartTime % 60 + StringUtil.getStringRes((Context)this, R.string.second)));
            }
            this.tv_breaklineRetryconnectCount.setText((CharSequence)(sslvpnStatus.breaklineRetryconnectCount / 10 + StringUtil.getStringRes((Context)this, R.string.count)));
            this.tv_netDelay.setText((CharSequence)(sslvpnStatus.netDelay + StringUtil.getStringRes((Context)this, R.string.millisecond)));
        } else {
            Log.d(this.TAG, "tunsportMode == 1");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CurrentStatusActivity.this.getCurSslvpnStatus(sslvpnStatus);
                    Message message = new Message();
                    message.what = 1;
                    CurrentStatusActivity.this.mHandler.sendMessage(message);
                    if (Compatibility.showPersionInfo()) {
                        byte[] cardId = new byte[64];
                        int[] cardIdLen = new int[1];
                        int ret = KeyWrapper.getInstance().getSN(cardId, cardIdLen);
                        if (ret != 0) {
                            Log.e(CurrentStatusActivity.this.TAG, "Get card sn return " + ret);
                            return;
                        }
                        String cardSN = new String(cardId, 0, cardIdLen[0]);
                        String strUrlPath = "http://192.168.20.72:58083/pams/scms/readcardcontroller/readcardinfo.do?cardNO=" + cardSN.toLowerCase();
                        Log.d(CurrentStatusActivity.this.TAG, "Request url : " + strUrlPath);
                        InputStream is = null;
                        String resultData = "";
                        HttpURLConnection conn = null;
                        try {
                            URL url = new URL(strUrlPath);
                            conn = (HttpURLConnection)url.openConnection();
                            conn.setRequestMethod("GET");
                            if (conn.getResponseCode() == 200) {
                                is = conn.getInputStream();
                                InputStreamReader isr = new InputStreamReader(is);
                                BufferedReader bufferReader = new BufferedReader(isr);
                                String inputLine = "";
                                while ((inputLine = bufferReader.readLine()) != null) {
                                    resultData = resultData + inputLine + "\n";
                                }
                                message = new Message();
                                message.what = 2;
                                message.obj = resultData;
                                CurrentStatusActivity.this.mHandler.sendMessage(message);
                                conn.disconnect();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(this.TAG, "onDestroy");
        if (this.myApplication.activityList != null) {
            this.myApplication.activityList.remove((Object)this);
        }
    }

    private void setNameAndDepartment(String result) {
        try {
            JSONArray jsonArray = new JSONArray("[" + result + "]");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                int flag = jsonObject.getInt("flag");
                if (flag == 0) {
                    this.tv_name.setText(R.string.unknown);
                    this.tv_dep.setText(R.string.unknown);
                    return;
                }
                JSONObject personInfoObj = jsonObject.getJSONObject("obj");
                String name = personInfoObj.getString("name");
                String depName = personInfoObj.getString("depName");
                this.tv_name.setText((CharSequence)name);
                this.tv_dep.setText((CharSequence)depName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.tv_name.setText(R.string.unknown);
            this.tv_dep.setText(R.string.unknown);
        }
    }

    private void setPage() {
        this.tv_transportMode.setText((CharSequence)StringUtil.getStringRes((Context)this, R.string.mode_tunnel));
        this.tv_listenPortText.setText(R.string.protectsubnet);
        String[] temp = CurrentStatusActivity.sslvpnStatus.protectNetworksegmentList.split(",");
        StringBuffer str = new StringBuffer();
        for (String ip : temp) {
            str.append(ip + "\n");
        }
        this.tv_listenPort.setText((CharSequence)str.toString());
        this.tv_recvDataPackage.setText((CharSequence)(CurrentStatusActivity.sslvpnStatus.recvDataSize + "KB"));
        this.tv_sendDataPackage.setText((CharSequence)(CurrentStatusActivity.sslvpnStatus.sendDataSize + "KB"));
        if (CurrentStatusActivity.sslvpnStatus.dataServerStartTime < 60) {
            this.tv_serviceStarttime.setText((CharSequence)(CurrentStatusActivity.sslvpnStatus.dataServerStartTime + StringUtil.getStringRes((Context)this, R.string.second)));
        } else {
            this.tv_serviceStarttime.setText((CharSequence)(CurrentStatusActivity.sslvpnStatus.dataServerStartTime / 60 + StringUtil.getStringRes((Context)this, R.string.minute) + CurrentStatusActivity.sslvpnStatus.dataServerStartTime % 60 + StringUtil.getStringRes((Context)this, R.string.second)));
        }
        this.tv_breaklineRetryconnectCount.setText((CharSequence)(CurrentStatusActivity.sslvpnStatus.breaklineRetryconnectCount / 10 + StringUtil.getStringRes((Context)this, R.string.count)));
        this.tv_netDelay.setText((CharSequence)(CurrentStatusActivity.sslvpnStatus.netDelay + StringUtil.getStringRes((Context)this, R.string.millisecond)));
    }

    private void getCurSslvpnStatus(SslvpnStatus sslvpnStatus) {
        String temp = null;
        int vpnstatelen = 0;
        byte[] vpnstate = new byte[4096];
        int res = this.myApplication.sslvpn.getStatus(sslvpnStatus);
        if (res != 0 || sslvpnStatus == null) {
            return;
        }
        Log.d("CurrentStateActivity", "vpnstatelen = " + vpnstatelen);
        Log.d("CurrentStateActivity", "vpnstate = " + temp);
        if (vpnstatelen <= 0) {
            Log.d("CurrentStateActivity", "vpnstatelen = " + vpnstatelen);
            return;
        }
    }
}

