/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.xdja.safeclient.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceListActivity
extends Activity {
    public static final String LOG_TAG = DeviceListActivity.class.getSimpleName();
    private BluetoothAdapter mBluetoothAdapter;
    private TextView mTextViewScanningHint;
    private ListView newDevicesListView;
    List<BluetoothDevice> deviceList;
    private DeviceAdapter deviceAdapter;
    Map<String, Integer> devRssiValues;
    private static final long SCAN_PERIOD = 5000L;
    private Handler mHandler;
    private Intent resultIntent;
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(final BluetoothDevice device, final int rssi, byte[] scanRecord) {
            DeviceListActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DeviceListActivity.this.addDevice(device, rssi);
                }
            });
        }
    };
    private AdapterView.OnItemClickListener mDeviceClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            BluetoothDevice device = DeviceListActivity.this.deviceList.get(position);
            Log.d((String)LOG_TAG, (String)"stop on item click ...");
            DeviceListActivity.this.mBluetoothAdapter.stopLeScan(DeviceListActivity.this.mLeScanCallback);
            Bundle b = new Bundle();
            b.putString("android.bluetooth.device.extra.DEVICE", device.getAddress());
            DeviceListActivity.this.resultIntent = new Intent();
            DeviceListActivity.this.resultIntent.putExtras(b);
            DeviceListActivity.this.setResult(-1, DeviceListActivity.this.resultIntent);
            Log.d((String)LOG_TAG, (String)"set reslut ...");
            DeviceListActivity.this.finish();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        Log.d((String)LOG_TAG, (String)"onCreate...");
        super.onCreate(savedInstanceState);
        this.getWindow().setFeatureInt(7, R.layout.title_bar);
        this.setContentView(R.layout.activity_device_list);
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.gravity = 48;
        layoutParams.y = 200;
        this.mHandler = new Handler();
        BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        Log.d((String)LOG_TAG, (String)"populateList...");
        this.deviceList = new ArrayList<BluetoothDevice>();
        this.deviceAdapter = new DeviceAdapter((Context)this, this.deviceList);
        this.devRssiValues = new HashMap<String, Integer>();
        this.newDevicesListView = (ListView)this.findViewById(R.id.new_devices);
        this.newDevicesListView.setAdapter((ListAdapter)this.deviceAdapter);
        this.newDevicesListView.setOnItemClickListener(this.mDeviceClickListener);
        this.mTextViewScanningHint = (TextView)this.findViewById(R.id.scanning_hint);
    }

    private void scanLeDevice(boolean enable) {
        if (enable) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)LOG_TAG, (String)"stop Le scanning after 5 seconds ...");
                    DeviceListActivity.this.mBluetoothAdapter.stopLeScan(DeviceListActivity.this.mLeScanCallback);
                }
            }, 5000L);
            Log.d((String)LOG_TAG, (String)"start Le scanning ...");
            this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
        } else {
            Log.d((String)LOG_TAG, (String)"stop Le scanning ...");
            this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        }
    }

    private void addDevice(BluetoothDevice device, int rssi) {
        Log.d((String)LOG_TAG, (String)"add device ...");
        boolean alreadyFound = false;
        for (BluetoothDevice listDev : this.deviceList) {
            if (!listDev.getAddress().equals(device.getAddress())) continue;
            alreadyFound = true;
            break;
        }
        this.devRssiValues.put(device.getAddress(), rssi);
        if (!alreadyFound) {
            this.deviceList.add(device);
            this.mTextViewScanningHint.setVisibility(8);
            this.deviceAdapter.notifyDataSetChanged();
        }
    }

    public void onStart() {
        super.onStart();
        this.scanLeDevice(true);
    }

    public void onStop() {
        super.onStop();
        this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
    }

    protected void onDestroy() {
        Log.d((String)LOG_TAG, (String)"onDestory...");
        super.onDestroy();
        this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
    }

    protected void onPause() {
        super.onPause();
        this.scanLeDevice(false);
    }

    class DeviceAdapter
    extends BaseAdapter {
        Context context;
        List<BluetoothDevice> devices;
        LayoutInflater inflater;

        public DeviceAdapter(Context context, List<BluetoothDevice> devices) {
            this.context = context;
            this.inflater = LayoutInflater.from((Context)context);
            this.devices = devices;
        }

        public int getCount() {
            return this.devices.size();
        }

        public Object getItem(int position) {
            return this.devices.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewGroup vg = convertView != null ? (ViewGroup)convertView : (ViewGroup)this.inflater.inflate(R.layout.device_element, null);
            BluetoothDevice device = this.devices.get(position);
            TextView tvadd = (TextView)vg.findViewById(R.id.address);
            TextView tvname = (TextView)vg.findViewById(R.id.name);
            TextView tvpaired = (TextView)vg.findViewById(R.id.paired);
            TextView tvrssi = (TextView)vg.findViewById(R.id.rssi);
            tvrssi.setVisibility(0);
            byte rssival = (byte)DeviceListActivity.this.devRssiValues.get(device.getAddress()).intValue();
            if (rssival != 0) {
                tvrssi.setText((CharSequence)("Rssi = " + String.valueOf(rssival)));
            }
            tvname.setText((CharSequence)device.getName());
            tvadd.setText((CharSequence)device.getAddress());
            if (device.getBondState() == 12) {
                Log.i((String)LOG_TAG, (String)("device::" + device.getName()));
                tvname.setTextColor(-1);
                tvadd.setTextColor(-1);
                tvpaired.setTextColor(-7829368);
                tvpaired.setVisibility(0);
                tvpaired.setText(R.string.paired);
                tvrssi.setVisibility(0);
                tvrssi.setTextColor(-1);
            } else {
                tvname.setTextColor(-1);
                tvadd.setTextColor(-1);
                tvpaired.setVisibility(8);
                tvrssi.setVisibility(0);
                tvrssi.setTextColor(-1);
            }
            return vg;
        }
    }
}

