/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.adapter.ListViewAdapter;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.safeclient.utils.Log;
import java.util.ArrayList;

public class LogQueryActivity
extends BaseActivity {
    private ProgressBar progressBar = null;
    private String pathStr;
    private final String mLogFileName = "safeclient.log";
    private String mLogFilePath;
    private ArrayList<String> mStrArray = null;
    private ListView mLogQueryListView = null;
    private ListViewAdapter mAdapter = null;
    private MyApplication myApplication = null;
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    LogQueryActivity.this.setListItems();
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_log_query);
        this.pathStr = this.getFilesDir().getAbsolutePath() + "/";
        this.mLogFilePath = this.pathStr + "safeclient.log";
        this.progressBar = (ProgressBar)this.findViewById(R.id.log_query_progressbar);
        this.mStrArray = new ArrayList();
        this.initListView();
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mRightBtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.initLeftBtn();
        this.initTitleText();
        this.myApplication = (MyApplication)this.getApplication();
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("LogQueryActivity", "onDestroy");
        this.mStrArray.clear();
        this.mStrArray = null;
        this.mAdapter = null;
        this.mHandler = null;
        if (this.myApplication.activityList != null) {
            this.myApplication.activityList.remove((Object)this);
        }
    }

    private void initListView() {
        this.mLogQueryListView = (ListView)this.findViewById(R.id.log_query_listview);
        Log.d("before initListView", "mStrArray.size() = " + this.mStrArray.size());
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
        FileUtil.readLogOfCurDay(this.mLogFilePath, this.mStrArray, this.mHandler);
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    private void setListItems() {
        if (this.mStrArray == null) {
            return;
        }
        this.mAdapter = new ListViewAdapter((Context)this, this.mStrArray, R.layout.list_tiem_log_query, R.id.logquerylistItemText){

            public boolean isEnabled(int position) {
                return false;
            }

            @Override
            public void setBackground(int position, View convertView) {
            }
        };
        Log.d("after setListItems", "mAdapter.getCount() = " + this.mAdapter.getCount());
        Log.d("after setListItems", "mStrArray.size() = " + this.mStrArray.size());
        this.mLogQueryListView.setAdapter((ListAdapter)this.mAdapter);
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        this.mTitleText.setText(R.string.log_query);
    }
}

