/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.event.TelnetResultCallback;
import com.xdja.safeclient.ui.AlertUtil;

public class NetworkCheckActivity
extends BaseActivity {
    private TextView networkStatus;
    private Button checkBt;
    private EditText telnetIPEt;
    private EditText telnetPortEt;
    private static final String TAG = "NetworkCheckActivity";
    private TelephonyManager telephonyManager;
    private PhoneStateListener listener;
    private static final int NETWORK_WIFI = 0;
    private static final int NETWORK_4G = 1;
    private static final int NETWORK_2G = 2;
    private static final int NETWORK_NONE = 3;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_network_check);
        this.networkStatus = (TextView)this.findViewById(R.id.network_status);
        this.checkBt = (Button)this.findViewById(R.id.telnet_test);
        this.telnetIPEt = (EditText)this.findViewById(R.id.telnet_ip);
        this.telnetPortEt = (EditText)this.findViewById(R.id.telnet_port);
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mRightBtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.telephonyManager = (TelephonyManager)this.getSystemService("phone");
        this.telnetIPEt.setText((CharSequence)new String(MyApplication.myApplication.sslClientConfig.gateWayIp));
        this.telnetPortEt.setText((CharSequence)String.valueOf(MyApplication.myApplication.sslClientConfig.gateWayPort));
        this.checkBt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NetworkCheckActivity.this.telnetTest();
            }
        });
        this.listener = new PhoneListener();
        this.telephonyManager.listen(this.listener, 256);
        this.checkBt.callOnClick();
        this.initLeftBtn();
        this.initTitleText();
    }

    protected void onResume() {
        super.onResume();
        this.telephonyManager.listen(this.listener, 256);
    }

    protected void onPause() {
        super.onPause();
        this.telephonyManager.listen(this.listener, 0);
    }

    private void updateSignal() {
    }

    private void telnetTest() {
        String ip = this.telnetIPEt.getEditableText().toString();
        int port = Integer.parseInt(this.telnetPortEt.getEditableText().toString());
        this.checkBt.setClickable(false);
        this.checkBt.setText((CharSequence)this.getString(R.string.connecting));
        Function.telnet(ip, port, 10000, new TelnetResultCallback(){

            @Override
            public void onTimeout() {
                MyApplication.myApplication.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        AlertUtil.popAlert((Context)NetworkCheckActivity.this, NetworkCheckActivity.this.getString(R.string.alert), NetworkCheckActivity.this.getString(R.string.connect_timeout));
                        NetworkCheckActivity.this.checkBt.setClickable(true);
                        NetworkCheckActivity.this.checkBt.setText((CharSequence)NetworkCheckActivity.this.getString(R.string.connect));
                    }
                });
            }

            @Override
            public void onSuccess() {
                MyApplication.myApplication.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        AlertUtil.popAlert((Context)NetworkCheckActivity.this, NetworkCheckActivity.this.getString(R.string.alert), NetworkCheckActivity.this.getString(R.string.connect_success));
                        NetworkCheckActivity.this.checkBt.setClickable(true);
                        NetworkCheckActivity.this.checkBt.setText((CharSequence)NetworkCheckActivity.this.getString(R.string.connect));
                    }
                });
            }

            @Override
            public void onError(final int err) {
                MyApplication.myApplication.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        AlertUtil.popAlert((Context)NetworkCheckActivity.this, NetworkCheckActivity.this.getString(R.string.alert), NetworkCheckActivity.this.getString(R.string.connect_error) + err);
                        NetworkCheckActivity.this.checkBt.setClickable(true);
                        NetworkCheckActivity.this.checkBt.setText((CharSequence)NetworkCheckActivity.this.getString(R.string.connect));
                    }
                });
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        this.mTitleText.setText(R.string.network_check);
    }

    private int getNetworkType() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            String netType = networkInfo.getTypeName();
            if (netType.equalsIgnoreCase("WIFI")) {
                return 0;
            }
            if (netType.equalsIgnoreCase("MOBILE")) {
                return this.isFastMobileNetwork() ? 1 : 2;
            }
            return 3;
        }
        return 3;
    }

    private boolean isFastMobileNetwork() {
        return this.telephonyManager.getNetworkType() == 13;
    }

    private class PhoneListener
    extends PhoneStateListener {
        private PhoneListener() {
        }

        @RequiresApi(api=23)
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            int level = signalStrength.getLevel();
            int networkType = NetworkCheckActivity.this.getNetworkType();
            StringBuffer status = new StringBuffer();
            status.append(NetworkCheckActivity.this.getString(R.string.current_network));
            switch (networkType) {
                case 0: {
                    status.append("wifi");
                    break;
                }
                case 1: {
                    status.append("4G");
                    break;
                }
                case 2: {
                    status.append("2G");
                    break;
                }
                case 3: {
                    status.append(NetworkCheckActivity.this.getString(R.string.no_network));
                }
            }
            status.append("." + NetworkCheckActivity.this.getString(R.string.signal_strength) + level);
            NetworkCheckActivity.this.networkStatus.setText((CharSequence)status.toString());
        }
    }
}

