/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity.sz;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.os.AsyncTask;
import android.os.Bundle;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.api.VPN;
import com.xdja.sslvpn.api.VPNApi;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StartVpnActivity
extends Activity {
    private String TAG = "SZStartVpnActivity";
    private static final int start_tunvpn_ok = 0;
    private static final int start_tunvpn_failed = -1;
    private static final int user_not_permit = -2;
    private VPN vpnApi;
    private String userPin;
    private long connectTime = 30000L;
    private String mLogFileName = "call_safeclient.log";
    private String filePath;
    File externalFilesDir;
    File targetFile;
    LooperStatus looperStatus;
    Task task;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.userPin = this.getIntent().getStringExtra("PIN");
        this.vpnApi = new VPN((Context)this);
        this.buildPrivateLogPath();
        this.buildTargetLogPath();
        Log.i(this.TAG, "----------onCreate");
        this.writeData("----------onCreate");
        this.writeData("---------call StartVpnActivity");
        this.startTunVpnService();
    }

    void buildPrivateLogPath() {
        String appPrivatePath = this.getFilesDir().getAbsolutePath() + "/";
        File dirPath = new File(appPrivatePath);
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        this.filePath = dirPath.getAbsolutePath() + "/" + this.mLogFileName;
    }

    void buildTargetLogPath() {
        this.externalFilesDir = this.getExternalFilesDir(null);
        if (this.externalFilesDir != null) {
            this.targetFile = new File(this.externalFilesDir.getPath() + "/" + this.mLogFileName);
        } else {
            Log.i(this.TAG, "buildTargetLogPath---------externalFilesDir error");
            this.writeData("---------buildTargetLogPath-->externalFilesDir error");
        }
    }

    public void startTunVpnService() {
        this.writeData("call startTunVpnSerivce()");
        Intent itt = VpnService.prepare((Context)this);
        if (itt != null) {
            Log.d(this.TAG, "startActivityForResult...");
            this.writeData("first start...vpn");
            this.writeData("call startTunVpnSerivce()--->startActivityForResult(itt,0)");
            this.startActivityForResult(itt, 0);
            FileUtil.copeFile(new File(this.filePath), this.targetFile);
        } else {
            Log.d(this.TAG, "onActivityResult...");
            this.writeData("N*** start...vpn");
            Intent intent = new Intent((Context)this, TunVpnService.class);
            intent.putExtra("SafePin", this.userPin);
            ComponentName name = this.startService(intent);
            if (name == null) {
                Log.i(this.TAG, "\u70fd\u706b\u8c03\u7528\u542f\u52a8\u5b89\u5168\u5ba2\u6237\u7aef\u51fa\u9519--------");
                this.writeData("\u70fd\u706b\u8c03\u7528\u542f\u52a8\u5b89\u5168\u5ba2\u6237\u7aef\u51fa\u9519--------");
                this.setResult(0);
            } else {
                Log.i(this.TAG, "\u70fd\u706b\u8c03\u7528-----\u670d\u52a1\u542f\u52a8----\u5f00\u59cb\u8f6e\u8be2\u8fde\u63a5\u7f51\u5173\u72b6\u6001");
                this.writeData("\u70fd\u706b\u8c03\u7528-----\u670d\u52a1\u542f\u52a8----\u5f00\u59cb\u8f6e\u8be2\u8fde\u63a5\u7f51\u5173\u72b6\u6001");
                this.looperStatus = new LooperStatus();
                this.looperStatus.execute(new Void[0]);
            }
        }
    }

    protected void onActivityResult(int request, int result, Intent data) {
        int permit = 0;
        if (-1 == result) {
            ComponentName name;
            Log.d(this.TAG, "onActivityResult , user permit");
            Intent ittTunVpn = new Intent((Context)this, TunVpnService.class);
            if (!"".equals(this.userPin) && this.userPin != null) {
                ittTunVpn.putExtra("SafePin", this.userPin);
            }
            if ((name = this.startService(ittTunVpn)) == null) {
                Log.i(this.TAG, "start TunVpnService failed");
                permit = -1;
            } else {
                Log.i(this.TAG, "start TunVpnService success " + name.toString());
                permit = 0;
            }
        } else {
            permit = -2;
            Log.i(this.TAG, "onActivityResult , user not permit:" + result);
        }
        this.writeData("onActivityResult-------permit:" + permit);
        this.task = new Task();
        this.task.execute(new Integer[]{permit});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(String content) {
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(this.filePath, true);
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeline = dateFormat.format(new Date());
            bw.write(timeline + " :" + content + "\r\n");
            bw.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        Log.i(this.TAG, "-------------\u5173\u95ed\u70fd\u706b  startVpnActivity");
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel(true);
            this.task = null;
        }
        if (this.looperStatus != null && !this.looperStatus.isCancelled()) {
            this.looperStatus.cancel(true);
            this.looperStatus = null;
        }
    }

    private class Task
    extends AsyncTask<Integer, Integer, Integer> {
        private Task() {
        }

        protected Integer doInBackground(Integer ... params) {
            if (params[0] != 0) {
                Log.i(StartVpnActivity.this.TAG, "start TunVpnService error:" + params[0]);
                return 2;
            }
            long curTime = System.currentTimeMillis();
            while (true) {
                VPNApi.StateResult result;
                if ((result = StartVpnActivity.this.vpnApi.getStatus()).getCode() == 0) {
                    StartVpnActivity.this.writeData("vpn connect success");
                    return 0;
                }
                if (result.getCode() == 1) {
                    Log.e(StartVpnActivity.this.TAG, "CONNECTING " + result.getComment() + ":" + result.getOriginalCode());
                    StartVpnActivity.this.writeData("vpn connect is  CONNECTING");
                }
                if (result.getCode() == 2) {
                    StartVpnActivity.this.writeData("vpn connect is  FAILED");
                    return 2;
                }
                if (System.currentTimeMillis() - curTime > StartVpnActivity.this.connectTime) {
                    StartVpnActivity.this.writeData("vpn connect timeout");
                    return 2;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        protected void onPostExecute(Integer result) {
            Log.i(StartVpnActivity.this.TAG, "onPostExecute");
            Intent intent = StartVpnActivity.this.getIntent();
            intent.putExtra("Package", "com.xdja.sjj1320client");
            intent.putExtra("Activity", "StartVpnActivity");
            if (result == 0) {
                StartVpnActivity.this.writeData("onPostExecute---- ");
                StartVpnActivity.this.setResult(-1, intent);
            } else {
                StartVpnActivity.this.writeData("onPostExecute----result_canceled");
                StartVpnActivity.this.setResult(0, intent);
            }
            Log.i(StartVpnActivity.this.TAG, "-------------filePath:" + StartVpnActivity.this.filePath);
            Log.i(StartVpnActivity.this.TAG, "-------------targetFile:" + StartVpnActivity.this.targetFile);
            FileUtil.copeFile(new File(StartVpnActivity.this.filePath), StartVpnActivity.this.targetFile);
            StartVpnActivity.this.finish();
        }
    }

    class LooperStatus
    extends AsyncTask<Void, Void, Integer> {
        LooperStatus() {
        }

        protected Integer doInBackground(Void ... params) {
            long curTime = System.currentTimeMillis();
            while (true) {
                VPNApi.StateResult result;
                if ((result = StartVpnActivity.this.vpnApi.getStatus()).getCode() == 0) {
                    Log.i(StartVpnActivity.this.TAG, "\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u6210\u529f");
                    StartVpnActivity.this.writeData("\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u6210\u529f");
                    StartVpnActivity.this.writeData("vpn connect success");
                    return 0;
                }
                if (result.getCode() == 1) {
                    Log.i(StartVpnActivity.this.TAG, "\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u4e2d.......");
                    Log.e(StartVpnActivity.this.TAG, "CONNECTING " + result.getComment() + ":" + result.getOriginalCode());
                    StartVpnActivity.this.writeData("\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u4e2d.......");
                    StartVpnActivity.this.writeData("vpn connect is  CONNECTING");
                }
                if (result.getCode() == 2) {
                    Log.i(StartVpnActivity.this.TAG, "\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u5931\u8d25.......");
                    StartVpnActivity.this.writeData("\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u5931\u8d25.......");
                    StartVpnActivity.this.writeData("vpn connect is  FAILED");
                    return 2;
                }
                if (System.currentTimeMillis() - curTime > StartVpnActivity.this.connectTime) {
                    Log.i(StartVpnActivity.this.TAG, "\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u8d85\u65f6.......\u5931\u8d25");
                    StartVpnActivity.this.writeData("\u8f6e\u8be2\u72b6\u6001\u67e5\u8be2----\u8fde\u63a5\u8d85\u65f6.......\u5931\u8d25");
                    StartVpnActivity.this.writeData("vpn connect timeout");
                    return 2;
                }
                if (result.getCode() == -1) {
                    StartVpnActivity.this.vpnApi.start();
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        protected void onPostExecute(Integer result) {
            super.onPostExecute((Object)result);
            Intent intent = StartVpnActivity.this.getIntent();
            intent.putExtra("Package", "com.xdja.sjj1320client");
            intent.putExtra("Activity", "StartVpnActivity");
            if (result == 0) {
                Log.i(StartVpnActivity.this.TAG, "\u8f6e\u8be2\u72b6\u6001>>>\u7ed3\u679c...\u8fde\u63a5\u6210\u529f");
                StartVpnActivity.this.writeData("\u8f6e\u8be2\u72b6\u6001>>>\u7ed3\u679c...\u8fde\u63a5\u6210\u529f ");
                StartVpnActivity.this.writeData("onPostExecute---- ");
                StartVpnActivity.this.setResult(-1, intent);
            } else {
                Log.i(StartVpnActivity.this.TAG, "\u8f6e\u8be2\u72b6\u6001>>>\u7ed3\u679c...\u8fde\u63a5\u5931\u8d25");
                StartVpnActivity.this.writeData("\u8f6e\u8be2\u72b6\u6001>>>\u7ed3\u679c...\u8fde\u63a5\u5931\u8d25");
                StartVpnActivity.this.writeData("onPostExecute----result_canceled");
                StartVpnActivity.this.setResult(0, intent);
            }
            Log.i(StartVpnActivity.this.TAG, "-------------filePath:" + StartVpnActivity.this.filePath);
            Log.i(StartVpnActivity.this.TAG, "-------------targetFile:" + StartVpnActivity.this.targetFile);
            FileUtil.copeFile(new File(StartVpnActivity.this.filePath), StartVpnActivity.this.targetFile);
            StartVpnActivity.this.writeData("\u8f6e\u8be2\u72b6\u6001>>>\u5173\u95edactivity");
            StartVpnActivity.this.finish();
        }
    }
}

