/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.xdja.safeclient.R;
import java.util.ArrayList;

public class ListViewAdapter
extends BaseAdapter {
    private ArrayList<String> mListItems;
    private int mResource;
    private int mItemTextViewId;
    private LayoutInflater mLayoutInflater;

    public ListViewAdapter(Context mContext, ArrayList<String> mListItems, int mResource, int mItemTextViewId) {
        this.mListItems = mListItems;
        this.mResource = mResource;
        this.mItemTextViewId = mItemTextViewId;
        this.mLayoutInflater = (LayoutInflater)mContext.getSystemService("layout_inflater");
    }

    public int getCount() {
        return this.mListItems.size();
    }

    public Object getItem(int position) {
        return this.mListItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = this.mLayoutInflater.inflate(this.mResource, null);
            holder = new ViewHolder();
            holder.text = (TextView)convertView.findViewById(this.mItemTextViewId);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        this.setBackground(position, convertView);
        this.setItemViewAttribute((View)holder.text);
        this.bindView((View)holder.text, this.mListItems.get(position));
        return convertView;
    }

    private void bindView(View view, String str) {
        if (view instanceof TextView) {
            ((TextView)view).setText((CharSequence)str);
        }
    }

    public View setItemViewAttribute(View view) {
        return view;
    }

    public void setBackground(int position, View convertView) {
        convertView.setBackgroundResource(this.getListItemBG(position));
    }

    private int getListItemBG(int position) {
        if (1 == this.mListItems.size()) {
            return R.drawable.list_item_single;
        }
        if (position == 0) {
            return R.drawable.list_item_top;
        }
        if (position == this.mListItems.size() - 1) {
            return R.drawable.list_item_bottom;
        }
        return R.drawable.list_item_middle;
    }

    static class ViewHolder {
        TextView text;

        ViewHolder() {
        }
    }
}

