/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.safeclient.R;
import com.xdja.safeclient.bean.LanguageBean;
import java.util.List;

public class SwitchLanguageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<LanguageBean> languageList;
    private int selectedPosition = -1;

    public SwitchLanguageAdapter(Context context, List<LanguageBean> languageList, int selectedPosition) {
        this.context = context;
        this.languageList = languageList;
        this.selectedPosition = selectedPosition;
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.switch_language_item, null));
    }

    public void onBindViewHolder(final ViewHolder holder, final int position) {
        LanguageBean language = this.languageList.get(position);
        holder.tv_language.setText((CharSequence)language.getName());
        holder.entireLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SwitchLanguageAdapter.this.selectedPosition = position;
                holder.rb_choose.setChecked(true);
                SwitchLanguageAdapter.this.notifyDataSetChanged();
            }
        });
        holder.rb_choose.setClickable(false);
        if (position == this.selectedPosition) {
            holder.rb_choose.setChecked(true);
        } else {
            holder.rb_choose.setChecked(false);
        }
    }

    public int getItemCount() {
        return this.languageList.size();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        RelativeLayout entireLayout;
        TextView tv_language;
        RadioButton rb_choose;

        public ViewHolder(View itemView) {
            super(itemView);
            this.entireLayout = (RelativeLayout)itemView.findViewById(R.id.entire_layout);
            this.tv_language = (TextView)itemView.findViewById(R.id.language);
            this.rb_choose = (RadioButton)itemView.findViewById(R.id.choose);
        }
    }
}

