/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.event;

import com.xdja.safeclient.event.SDCardStateChangeListener;
import com.xdja.safeclient.event.SimStateChangedListener;
import java.util.ArrayList;
import java.util.List;

public class EventManager {
    private static EventManager manager = new EventManager();
    private List<SimStateChangedListener> simList = new ArrayList<SimStateChangedListener>();
    private List<SDCardStateChangeListener> sdList = new ArrayList<SDCardStateChangeListener>();

    private EventManager() {
    }

    public static EventManager getInstance() {
        return manager;
    }

    public boolean addSimStateChangedListener(SimStateChangedListener listener) {
        return this.simList.add(listener);
    }

    public boolean removeSimStateListener(SimStateChangedListener listener) {
        return this.simList.remove(listener);
    }

    public boolean addSDCardStateChangedListener(SDCardStateChangeListener listener) {
        return this.sdList.add(listener);
    }

    public boolean removeSDCardStateChangedListener(SDCardStateChangeListener listener) {
        return this.sdList.remove(listener);
    }

    public synchronized void onSDCardStateChanged(int state) {
        for (SDCardStateChangeListener listener : this.sdList) {
            listener.onSDCardStateChanged(state);
        }
    }

    public synchronized void onSimStateChanged(int prevState, int curState) {
        for (SimStateChangedListener listener : this.simList) {
            listener.onSimStateChanged(prevState, curState);
        }
    }
}

