/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.format.DateFormat;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.LaunchUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.StatusCode;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Compatibility {
    private static final String TAG = "Compatibility";
    public static final int AREA_VERSION_GENERAL = 0;
    public static final int AREA_VERSION_LIAONING_SHENGTING_BASE = 1000;
    public static final int AREA_VERSION_LIAOING_ZHIAN = 1001;
    public static final int AREA_VERSION_XINING_BASE = 2000;
    public static final int AREA_VERSION_XINING_VIDEO = 2001;
    public static final int AREA_VERSION_GUOSHUI = 3001;
    public static final int AREA_VERSION_ZHANG_JIA_JIE_BASE = 7000;
    public static final int AREA_VERSION_XIAN_BASE = 8000;
    public static final int AREA_VERSION_ZHEJIANG_DIANXIN_BASE = 9000;
    public static final int AREA_VERSION_ZHENGZHOU_SHIJU = 6000;
    public static final int AREA_VERSION_GUIYANG_EMM = 10000;
    public static final int AREA_VERSION_YANGZHOU_SHIJU = 12000;
    public static final int AREA_VERSION_JIANGSU_YANCHENG = 13000;
    public static final int AREA_VERSION_JIANGSU_TAIZHOU = 14000;
    public static final int AREA_VERSION_LIAONING_SHENGTING = 15000;
    public static final int AREA_VERSION_LANZHOU_GONGAN = 16000;
    public static final int AREA_VERSION_GUANGDONG_SHENGTING = 17000;
    public static final int AREA_VERSION_XDJA = 18000;
    public static final int AREA_VERSION_SHANXI_SHENGTING = 19000;
    public static final int AREA_VERSION_WUHAN_SHIJU = 20000;
    private static int areaVersion = 0;
    private static final String CAPTURE_FOLDER = "captures";
    private static final String LOGS_FOLDER = "logs";
    public static final int CKMS_VERSION_CODE = 38182394;
    static final String SAFE_KEY_SERVICE_STANDARD = "com.xdja.safekeyservice";
    static final String SAFE_KEY_SERVICE_ZHE_JIANG = "com.xdja.safekeyservice.zjtel";
    public static final String STANDARD_CLSNAME = "com.xdja.scservice.presenter.activity.UpdatePresener";
    public static final String SPECIFIED_CLSNAME = "com.xdja.appupdate.activity.UpdateShowActivity";
    static Map<Integer, String> SAFE_KEY_SERVICE_PACKAGE_NAME_MAP = new HashMap<Integer, String>();

    public static int getAreaVersion() {
        return areaVersion;
    }

    public static void initAreaVersion() {
        areaVersion = 0;
    }

    public static int onServiceStop() {
        if (areaVersion / 1000 == 1) {
            Compatibility.onVPNStateChanged(1, 1001, 1001);
        }
        return 0;
    }

    public static int onVPNStateChanged(int result, int stage, int errCode) {
        if (areaVersion / 1000 == 1 && stage != 10) {
            Log.e(TAG, "heilongjiang shengting broadcast event  = " + stage + " action result = " + result + " comment = " + StatusCode.getStatusComment(stage));
            Intent intent = new Intent("com.xdja.safeclient.VPN_STATE_CHANGED");
            intent.putExtra("event", stage);
            intent.putExtra("state", result);
            MyApplication.myApplication.sendBroadcast(intent);
        }
        return 0;
    }

    public static int onSDCardEject() {
        if (areaVersion == 1000) {
            Function.exitApp((Context)MyApplication.myApplication);
        }
        return 0;
    }

    public static boolean isXiAnJWT() {
        return areaVersion == 8000;
    }

    public static String getTFPackage(Context context) {
        if (areaVersion == 2001) {
            return "com.xdja.safeclient";
        }
        return context.getPackageName();
    }

    public static String getSDCardFolder() {
        return "SafeClient";
    }

    private static File getStorageFolder(Context ctxt, boolean preferCache) {
        File root = Environment.getExternalStorageDirectory();
        if (!root.canWrite() || preferCache) {
            root = ctxt.getCacheDir();
        }
        if (root.canWrite()) {
            File dir = new File(root.getAbsolutePath() + File.separator + Compatibility.getSDCardFolder());
            if (!dir.exists()) {
                dir.mkdirs();
                Log.d(TAG, "Create directory " + dir.getAbsolutePath());
            }
            return dir;
        }
        return null;
    }

    private static File getSubFolder(Context ctxt, String subFolder, boolean preferCache) {
        File root = Compatibility.getStorageFolder(ctxt, preferCache);
        if (root != null) {
            File dir = new File(root.getAbsoluteFile() + File.separator + subFolder);
            dir.mkdirs();
            return dir;
        }
        return null;
    }

    public static File getLogsFolder(Context ctxt) {
        return Compatibility.getSubFolder(ctxt, LOGS_FOLDER, false);
    }

    public static File getLogsFile(Context ctxt) {
        File dir = Compatibility.getLogsFolder(ctxt);
        File outFile = null;
        if (dir != null) {
            Date d = new Date();
            StringBuffer fileName = new StringBuffer();
            fileName.append("safeclient");
            fileName.append("logs_");
            fileName.append(DateFormat.format((CharSequence)"yy-MM-dd_kkmmss", (Date)d));
            fileName.append(".txt");
            outFile = new File(dir.getAbsoluteFile() + File.separator + fileName.toString());
        }
        return outFile;
    }

    public static void cleanLogsFiles(Context ctxt) {
        File[] files;
        File logsFolder = Compatibility.getLogsFolder(ctxt);
        if (logsFolder != null && (files = logsFolder.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    public static boolean isZhangJiaJieBase() {
        return areaVersion / 7000 == 1;
    }

    public static void onStartedByThirdApp(Context context) {
        if (areaVersion == 1001) {
            LaunchUtil.start(context, SafeVerifyActivity.class);
        }
    }

    public static boolean isZhengZhouShiju() {
        return areaVersion / 6000 == 1;
    }

    public static boolean needBindAllIP() {
        boolean bindAllIP = true;
        switch (areaVersion) {
            case 12000: 
            case 13000: 
            case 14000: 
            case 15000: {
                Log.d(TAG, "Only bind 127.0.0.1");
                bindAllIP = false;
                break;
            }
            default: {
                bindAllIP = true;
            }
        }
        return bindAllIP;
    }

    public static String getCKMSPackageName() {
        return SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.get(9000);
    }

    public static String getSafeKeyServicePackageName() {
        return SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.get(0);
    }

    public static boolean isCKMSAppInstalled(Context context) {
        return Compatibility.isAppInstalled(context, Compatibility.getCKMSPackageName());
    }

    public static int getCKMSVersion(Context context) {
        try {
            PackageInfo packageInfo = Compatibility.getPackageInfo(context, Compatibility.getCKMSPackageName());
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("SafeClient", " getCKMSVersion--> package is not found.");
            return -1;
        }
    }

    public static boolean isSafeKeyServiceAppInstalled(Context context) {
        return Compatibility.isAppInstalled(context, Compatibility.getSafeKeyServicePackageName());
    }

    public static int getSafeKeyServiceVersion(Context context) {
        try {
            PackageInfo packageInfo = Compatibility.getPackageInfo(context, Compatibility.getSafeKeyServicePackageName());
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("SafeClient", " getSafeKeyServiceVersion---->package is not found.");
            return -1;
        }
    }

    static PackageInfo getPackageInfo(Context context, String packageName) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.getPackageInfo(packageName, 1);
    }

    static boolean isAppInstalled(Context context, String packageName) {
        boolean isInstalled = false;
        try {
            PackageInfo packageInfo = Compatibility.getPackageInfo(context, packageName);
            if (packageInfo != null) {
                isInstalled = true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("SafeClient", " package is not found. packageName:" + packageName);
        }
        return isInstalled;
    }

    public static boolean useZhongfuKey() {
        MyApplication application = MyApplication.myApplication;
        return application.propertiesConfig.hasZhongfuKey() == 1;
    }

    public static int[] getKeyDriverSort() {
        return new int[]{8, 1, 4};
    }

    public static int[] getKeyTypeSort() {
        return new int[]{0, 1, 3};
    }

    public static boolean disableXdjaChip() {
        return areaVersion == 17000 || areaVersion == 20000;
    }

    public static List<String> getTunDisallowedApps() {
        ArrayList<String> appList = new ArrayList<String>();
        if (areaVersion == 16000) {
            appList.add("lte.trunk.terminal.mdmclient");
            appList.add("lte.trunk.terminal.loguploader");
            appList.add("lte.trunk.terminal.touc");
            appList.add("lte.trunk.tapp");
            appList.add("lte.trunk.terminal.contacts");
            appList.add("lte.trunk.tapp.telephony");
            appList.add("lte.trunk.terminal.tmophone");
            return appList;
        }
        if (areaVersion == 17000) {
            appList.add("com.bit.pmcrg.dispatchclient");
            appList.add("com.android.providers.downloads");
            return appList;
        }
        return null;
    }

    public static void showNetTimeoutDialog() {
        if (areaVersion == 0) {
            MyApplication.myApplication.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    AlertUtil.popSystemAlert((Context)MyApplication.myApplication, "\u8fde\u63a5\u7f51\u5173\u8d85\u65f6", "\u5b89\u5168\u5ba2\u6237\u7aef\u53ef\u80fd\u88ab\u7cfb\u7edf\u9650\u5236\u8bbf\u95ee\u7f51\u7edc\uff0c\u8bf7\u5c1d\u8bd5\u70b9\u51fb'\u786e\u5b9a'\u5173\u95ed\u5ba2\u6237\u7aef\uff0c\u7136\u540e\u624b\u52a8\u91cd\u542f", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Function.exitApp((Context)MyApplication.myApplication);
                        }
                    });
                }
            });
        }
    }

    public static String getDeclaration() {
        if (areaVersion == 18000) {
            return MyApplication.myApplication.getString(R.string.xdja_declaration);
        }
        return MyApplication.myApplication.getString(R.string.declaration);
    }

    public static boolean showPersionInfo() {
        return areaVersion == 20000;
    }

    static {
        SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.put(0, SAFE_KEY_SERVICE_STANDARD);
        SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.put(9000, SAFE_KEY_SERVICE_ZHE_JIANG);
    }
}

