/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.xdja.safeclient.utils.Log;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtil {
    public static List<String> CHINA_MOBILE = new ArrayList<String>();
    public static List<String> CHINA_UNICOM = new ArrayList<String>();
    public static List<String> CHINA_TELECOM = new ArrayList<String>();
    public static final String CHINA_MOBILE_GPRS = "cmnet";
    public static final String CHINA_MOBILE_WAP = "cmwap";
    public static final String CHINA_MOBILE_MMS = "cmwap";
    public static final String CHINA_TELECOM_GRPS = "ctnet";
    public static final String CHINA_TELECOM_WAP = "ctwap";
    public static final String CHINA_TELECOM_CTLTE = "ctlte";
    public static final String CHINA_TELECOM_MMS = "ctwap";

    public static String getAPNName(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni.getExtraInfo();
    }

    public static boolean isChinaMobileAPN(String apnName) {
        return CHINA_MOBILE.indexOf(apnName) != -1;
    }

    public static boolean isChinaTelecomeAPN(String apnName) {
        return CHINA_TELECOM.indexOf(apnName) != -1;
    }

    public static String getIP(Context context) {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = ni.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            Log.e("WifiPreferenceIpAddress", ex.toString());
        }
        return "";
    }

    public static boolean netWorkisAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    static {
        CHINA_MOBILE.add(CHINA_MOBILE_GPRS);
        CHINA_MOBILE.add("cmwap");
        CHINA_MOBILE.add("cmwap");
        CHINA_TELECOM.add(CHINA_TELECOM_GRPS);
        CHINA_TELECOM.add("ctwap");
        CHINA_TELECOM.add("ctwap");
        CHINA_TELECOM.add(CHINA_TELECOM_CTLTE);
    }
}

