/*
 * Decompiled with CFR 0.152.
 */
package com.zfsimkeys.security;

import com.zfsimkeys.security.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.jce.X509Principal;

public class DataDeal {
    private char findHex(byte b) {
        int t = new Byte(b).intValue();
        int n = t = t < 0 ? t + 16 : t;
        if (t >= 0 && t <= 9) {
            return (char)(t + 48);
        }
        return (char)(t - 10 + 65);
    }

    public String byteToString(byte b) {
        int maskHigh = -16;
        int maskLow = 15;
        byte high = (byte)((b & maskHigh) >> 4);
        byte low = (byte)(b & maskLow);
        StringBuffer buf = new StringBuffer();
        buf.append(this.findHex(high));
        buf.append(this.findHex(low));
        return buf.toString();
    }

    public String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public String bytesToHexString(byte[] bArray, int len) {
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public byte[] int2Byte(int intValue) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            b[i] = (byte)(intValue >> 8 * (3 - i) & 0xFF);
            ++i;
        }
        return b;
    }

    public int byte2Int(byte[] b) {
        int intValue = 0;
        int i = 0;
        while (i < b.length) {
            intValue += (b[i] & 0xFF) << 8 * (3 - i);
            ++i;
        }
        return intValue;
    }

    public byte[] parseHexStringToBytes(String hex) {
        String tmp = hex.replaceAll("[^[0-9][a-f]]", "");
        byte[] bytes = new byte[tmp.length() / 2];
        String part = "";
        int i = 0;
        while (i < bytes.length) {
            part = "0x" + tmp.substring(i * 2, i * 2 + 2);
            bytes[i] = Long.decode(part).byteValue();
            ++i;
        }
        return bytes;
    }

    public byte[] hexStringToBytes(String hexString) {
        String chars = "0123456789ABCDEF";
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(chars.indexOf(hexChars[pos]) << 4 | chars.indexOf(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    public String Base64Encode(byte[] bData) {
        String sData = null;
        String strTmpData = Base64.encodeBytes(bData);
        String lineSep = System.getProperty("line.separator");
        int linelen = lineSep.length();
        int endIndex = strTmpData.indexOf(lineSep);
        boolean flag = true;
        while (endIndex != -1) {
            sData = flag ? strTmpData.substring(0, endIndex) : String.valueOf(sData) + strTmpData.substring(0, endIndex);
            strTmpData = strTmpData.substring(endIndex + linelen);
            flag = false;
            endIndex = strTmpData.indexOf(lineSep);
        }
        sData = flag ? strTmpData : String.valueOf(sData) + strTmpData;
        return sData;
    }

    public String Base64Encode(byte[] bData, int length) {
        int i = 0;
        byte[] arrayData = new byte[length];
        i = 0;
        while (i < length) {
            arrayData[i] = bData[i];
            ++i;
        }
        String sData = this.Base64Encode(arrayData);
        return sData;
    }

    public static byte[] Base64Decode(String sData) {
        byte[] bData = null;
        try {
            bData = Base64.decode(sData);
        }
        catch (Exception e) {
            bData = null;
            System.out.println("Base64\ufffd\ufffd\ufffd\ufffd\u02a7\ufffd\ufffd");
            e.printStackTrace();
        }
        return bData;
    }

    public void reverse_data1(byte[] data_buf, int offset, int len) {
        byte[] ptr = new byte[len];
        int tmpoffset = len - 1;
        System.arraycopy(data_buf, offset, ptr, 0, len);
        int i = 0;
        while (i < len / 2) {
            byte temp = ptr[i];
            ptr[i] = ptr[tmpoffset - i];
            ptr[tmpoffset - i] = temp;
            ++i;
        }
        System.arraycopy(ptr, 0, data_buf, offset, len);
    }

    public void reverse_data2(byte[] data_buf, int offset, int len) {
        byte[] ptr = new byte[len];
        System.arraycopy(data_buf, offset, ptr, 0, len);
        int i = 0;
        while (i < len) {
            byte temp = ptr[i];
            ptr[i] = ptr[3 + i];
            ptr[3 + i] = temp;
            temp = ptr[1 + i];
            ptr[1 + i] = ptr[2 + i];
            ptr[2 + i] = temp;
            i += 4;
        }
        System.arraycopy(ptr, 0, data_buf, offset, len);
    }

    private static String getEmailFromDN(String dn) {
        String EMAIL = "rfc822name";
        String EMAIL1 = "email";
        String EMAIL2 = "EmailAddress";
        String EMAIL3 = "E";
        String[] EMAILIDS = new String[]{EMAIL3, EMAIL2, EMAIL1, EMAIL};
        String email = null;
        String subinfo = null;
        String tarstr = null;
        int i = 0;
        while (i < EMAILIDS.length && email == null) {
            tarstr = String.valueOf(EMAILIDS[i]) + "=";
            int index = dn.indexOf(tarstr);
            if (index != -1) {
                subinfo = dn.substring(index);
                int endinex = subinfo.indexOf(",");
                email = endinex == -1 ? subinfo.substring(2) : subinfo.substring(2, endinex);
            }
            ++i;
        }
        return email;
    }

    public static String SMK_CertGetInfo(String cert, int infoType) {
        String info = null;
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            byte[] certBuf = DataDeal.Base64Decode(cert);
            ByteArrayInputStream ois = new ByteArrayInputStream(certBuf);
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            int itype = infoType;
            String infostr = null;
            String subinfo = null;
            int index = -1;
            switch (itype) {
                case 1: {
                    info = String.valueOf(oCert.getVersion());
                    break;
                }
                case 2: {
                    info = oCert.getSerialNumber().toString(16);
                    break;
                }
                case 3: {
                    info = oCert.getSigAlgName();
                    break;
                }
                case 4: {
                    infostr = oCert.getIssuerDN().getName();
                    index = infostr.indexOf("C=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(2);
                        break;
                    }
                    info = subinfo.substring(2, endinex);
                    break;
                }
                case 5: {
                    infostr = oCert.getIssuerDN().getName();
                    index = infostr.indexOf("O=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(2);
                        break;
                    }
                    info = subinfo.substring(2, endinex);
                    break;
                }
                case 6: {
                    infostr = oCert.getIssuerDN().getName();
                    index = infostr.indexOf("OU=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(3);
                        break;
                    }
                    info = subinfo.substring(3, endinex);
                    break;
                }
                case 7: {
                    infostr = oCert.getIssuerDN().getName();
                    index = infostr.indexOf("ST=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(3);
                        break;
                    }
                    info = subinfo.substring(3, endinex);
                    break;
                }
                case 8: {
                    infostr = oCert.getIssuerDN().getName();
                    index = infostr.indexOf("CN=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(3);
                        break;
                    }
                    info = subinfo.substring(3, endinex);
                    break;
                }
                case 9: {
                    infostr = oCert.getIssuerDN().getName();
                    index = infostr.indexOf("L=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(2);
                        break;
                    }
                    info = subinfo.substring(2, endinex);
                    break;
                }
                case 10: {
                    X509Principal certissuername = new X509Principal(oCert.getIssuerX500Principal().getEncoded());
                    infostr = certissuername.getName();
                    info = DataDeal.getEmailFromDN(infostr);
                    break;
                }
                case 11: {
                    Date beforedate = oCert.getNotBefore();
                    info = dateformat.format(beforedate);
                    break;
                }
                case 12: {
                    Date afterdate = oCert.getNotAfter();
                    info = dateformat.format(afterdate);
                    break;
                }
                case 13: {
                    infostr = oCert.getSubjectDN().getName();
                    index = infostr.indexOf("C=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(2);
                        break;
                    }
                    info = subinfo.substring(2, endinex);
                    break;
                }
                case 14: {
                    infostr = oCert.getSubjectDN().getName();
                    index = infostr.indexOf("O=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(2);
                        break;
                    }
                    info = subinfo.substring(2, endinex);
                    break;
                }
                case 15: {
                    infostr = oCert.getSubjectDN().getName();
                    index = infostr.indexOf("OU=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(3);
                        break;
                    }
                    info = subinfo.substring(3, endinex);
                    break;
                }
                case 16: {
                    infostr = oCert.getSubjectDN().getName();
                    index = infostr.indexOf("ST=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(3);
                        break;
                    }
                    info = subinfo.substring(3, endinex);
                    break;
                }
                case 17: {
                    infostr = oCert.getSubjectDN().getName();
                    index = infostr.indexOf("CN=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(3);
                        break;
                    }
                    info = subinfo.substring(3, endinex);
                    break;
                }
                case 18: {
                    infostr = oCert.getSubjectDN().getName();
                    index = infostr.indexOf("L=");
                    if (index == -1) break;
                    subinfo = infostr.substring(index);
                    int endinex = subinfo.indexOf(",");
                    if (endinex == -1) {
                        info = subinfo.substring(2);
                        break;
                    }
                    info = subinfo.substring(2, endinex);
                    break;
                }
                case 19: {
                    X509Principal certname = new X509Principal(oCert.getSubjectX500Principal().getEncoded());
                    infostr = certname.getName();
                    info = DataDeal.getEmailFromDN(infostr);
                    break;
                }
                case 22: {
                    info = new String(oCert.getExtensionValue("2.16.840.1.113732.2"));
                    info = info.substring(2);
                    break;
                }
                default: {
                    info = null;
                }
            }
            ((InputStream)ois).close();
        }
        catch (Exception e) {
            info = null;
            System.out.println("\u89e3\u6790\u8bc1\u4e66\u5931\u8d25");
            e.printStackTrace();
        }
        return info;
    }
}

