/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.base;

import com.longmai.security.plugin.base.BaseException;

public class PluginException
extends BaseException {
    protected int errorCode = -1;

    public PluginException(int errorCode, String errorMsg) {
        super(errorMsg);
        this.errorCode = errorCode;
    }

    public PluginException(int errorCode) {
        super(PluginException.getMessageFromErrorCode(errorCode));
        this.errorCode = errorCode;
    }

    public PluginException(String errorMsg) {
        super(errorMsg);
        this.errorCode = 1;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    protected static String getMessageFromErrorCode(int errorCode) {
        String result = null;
        switch (errorCode) {
            case 1: {
                result = "Unknown error - " + errorCode;
                break;
            }
            case 2: {
                result = "Data format or type error - " + errorCode;
                break;
            }
            case 3: {
                result = "The key to the invalid - " + errorCode;
                break;
            }
            case 4: {
                result = "Unknown to the algorithm - " + errorCode;
                break;
            }
            case 5: {
                result = "The current environment is not supported - " + errorCode;
                break;
            }
            case 6: {
                result = "Unknown device - " + errorCode;
                break;
            }
            case 7: {
                result = "Invalid connection - " + errorCode;
                break;
            }
            case 8: {
                result = "Generate APDU failure - " + errorCode;
                break;
            }
            case 9: {
                result = "Driver not found - " + errorCode;
                break;
            }
            case 10: {
                result = "Config not found - " + errorCode;
                break;
            }
            case 11: {
                result = "IO error - " + errorCode;
                break;
            }
            case 12: {
                result = "No devices found - " + errorCode;
                break;
            }
            case 13: {
                result = "Connection failed - " + errorCode;
                break;
            }
            case 16: {
                result = "Safety certification does not pass - " + errorCode;
                break;
            }
            case 17: {
                result = "Permission denied - " + errorCode;
            }
            case 20: {
                result = "The message digest algorithm does not match the SM2 signature - " + errorCode;
            }
            default: {
                result = "Unspecified error - " + errorCode;
            }
        }
        return result;
    }
}

