package com.xdja.safehelper.activity;

import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;


import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.net.BusinessRespAsync;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.safehelper.view.MyCustomDialog;

import io.reactivex.functions.Consumer;


/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/11/28 <br/>
 */
public class ForAdaptOldVhsmActivity extends BaseActivity {

    private BusinessRespAsync businessRespAsync;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sh_activity_for_adapt_old_vhsm);
        initView();
    }

    private Button btnOk;
    private EditText editIdentify;

    private void initView() {
        initToolbar(true, R.string.sh_for_adapt_old_vhsm_title);
        btnOk = findViewById(R.id.btn_ok);
        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                btnOkClick();
            }
        });

        editIdentify = findViewById(R.id.edit_identify);
        editIdentify.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s == null || s.length() == 0) {
                    btnOk.setEnabled(false);
                } else {
                    btnOk.setEnabled(true);
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
        businessRespAsync = new BusinessRespAsync();

    }

    private void btnOkClick() {
        String identify = editIdentify.getText().toString();
        if (TextUtils.isEmpty(identify)) {
            ToastUtils.makeText(this, R.string.sh_bind_id, Toast.LENGTH_SHORT).show();
            return;
        }
        showLoadingDialog(R.string.sh_verify_identify_loading);
        businessRespAsync.getImeisAndVerify(FuncUtils.getDevId(this), identify, new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
                if (integer == 0) {
                    showLockedDialog(R.string.sh_verify_identity_success);
                } else if (integer == ErrorCode.RET_PERSON_NOT_EXIST) {
                    ToastUtils.makeText(ForAdaptOldVhsmActivity.this,
                            R.string.sh_identity_not_in_system, Toast.LENGTH_SHORT).show();
                } else {
                    showLockedDialog(R.string.sh_verify_identity_fail);
                }
            }
        });
    }

    /**
     * 锁死弹框
     */
    private void showLockedDialog(final @StringRes int strRes) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(this)
                .setMessage(strRes)
                .setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        if (strRes == R.string.sh_verify_identity_success) {
                            ForAdaptOldVhsmActivity.this.finish();
                        }
                    }
                })
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }


}
