package com.xdja.safehelper.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyEvent;

import com.xdja.safehelper.ActivityStackManager;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.utils.ViewUtils;

public abstract class SHBaseActivity extends Activity {

    private AbstractCommonView  commonView;

    @SuppressLint("SourceLockedOrientationActivity")
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        //设置语言要放到  所有控件相关操作之前
        super.onCreate(savedInstanceState);
//        //默认设置竖屏
        if (this.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }
        ActivityStackManager.getInstance().add(this);
        commonView = getCommonView();
        commonView.onCreate(this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        commonView.onResume();

    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        ActivityStackManager.getInstance().remove(this);
        commonView.onDestroy();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        commonView.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            handleKeyBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void handleKeyBack() {
        if (ViewUtils.isKeyboardShown(this)) {
            ViewUtils.hideInputWindowDelay(this);
        } else {
            this.finish();
        }
    }

    abstract AbstractCommonView getCommonView();
}
