package com.xdja.safehelper.activity;

import android.Manifest;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputEditText;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.domain.DomainErrorCode;
import com.xdja.vhsm.domain.ServerConfigRepository;
import com.xdja.vhsm.permission.OnPermissionListener;
import com.xdja.vhsm.permission.SPermission;
import com.xdja.vhsm.utils.AssetsConfigUtils;
import com.xdja.vhsm.utils.ConfigUtils;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.vhsm.utils.ViewUtils;

import java.util.Timer;
import java.util.TimerTask;

import io.reactivex.functions.Consumer;

/**
 * <br>author: wzg@xdja.com <br/>
 * date:   2019/5/5 18:53 <br/>
 */
public class ServerConfigActivity extends BaseActivity {
    private TextInputEditText editText_ip;
    private TextInputEditText editText_port;
    private TextInputEditText editText_Address;
    private TextInputEditText editText_Address_port;

    private LinearLayout layoutIpPort;
    private LinearLayout layoutAddress;
    private Button btn_connect;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.sh_activity_server_config);

        initView();
        initData();
    }

    @Override
    public void onResume() {
        super.onResume();

        Log.d(tag, "onResume");

        if (isGrantedPermission()) {
            ViewUtils. showInputWindowDelay(this);
        } else {

            try {
                Timer timer = new Timer();
                timer.schedule(new TimerTask() {
                    @Override
                    public void run() {
                        requestPermission();
                    }
                }, 300);

            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }

    @Override
    public void onPause() {
        super.onPause();
        ViewUtils.hideInputWindowDelay(this);

        SPermission sPermission = SPermission.getsPermission();
        if (sPermission != null) {
            sPermission.activeSPermission();
        }
    }

    private void initView() {
        initToolbar();

        layoutIpPort = findViewById(R.id.layout_ip_port);
        layoutAddress = findViewById(R.id.layout_address);

        editText_ip = findViewById(R.id.edit_init_ip);
        editText_ip.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus) {
                }
            }
        });

        editText_port = findViewById(R.id.edit_init_port);
        editText_port.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus) {
                    validatePort(editText_port.getText().toString());
                }
            }
        });

        editText_Address = findViewById(R.id.edit_init_address);
        editText_Address_port = findViewById(R.id.edit_init_address_port);

        btn_connect = findViewById(R.id.btn_connect_config);
        btn_connect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onConnectClick();
            }
        });

    }

    Button btnSetting;

    private void initToolbar() {
        initToolbar(true, R.string.sh_setting_address_config);
        btnSetting = findViewById(R.id.btn_setting);
        btnSetting.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                layoutConfigClick();
            }
        });
    }

    private void initData() {
        //modify 2019年5月28日10:47:47 weizg
        //修改为不论是否有权限都获取内容，并展示；
        //权限申请修改为在onResume中进行

        //如果本地有IP和端口则显示（通过设置界面进入）
        String ip = getIp();
        int port = getPort();
        String address = getAddress();
        int addressPort = getAddressPort();

        String type = ConfigUtils.getType(getApplicationContext());

        editText_Address.setText(address);
        if (addressPort > 0) {
            editText_Address_port.setText("" + addressPort);
        }

        if (!TextUtils.isEmpty(ip) && port > 0) {
            editText_ip.setText(ip);
            editText_ip.setSelection(ip.length());
            editText_port.setText(String.valueOf(port));
        }

        if (TextUtils.isEmpty(type)) {
            if (!TextUtils.isEmpty(ip)) {
                showIpAndPort();
            } else {
                if (!TextUtils.isEmpty(address)) {
                    showAddress();
                } else {
                    showIpAndPort();
                }
            }
        } else if (ConfigUtils.KEY_initIp.equals(type)) {
            showIpAndPort();
        } else {
            showAddress();
        }
    }

    private String getIp() {
        String ip = ConfigUtils.getIP(getApplicationContext());
        if (TextUtils.isEmpty(ip)) {
            ip = AssetsConfigUtils.getInstance().getServerIp();
        }
        return ip;
    }

    private int getPort() {
        int port = ConfigUtils.getPort(getApplicationContext());
        if (port <= 0) {
            port = AssetsConfigUtils.getInstance().getServerIpPort();
        }
        return port;
    }

    private String getAddress() {
        String address = ConfigUtils.getAddress(getApplicationContext());
        if (TextUtils.isEmpty(address)) {
            address = AssetsConfigUtils.getInstance().getServerAddress();
        }
        return address;
    }

    private int getAddressPort() {
        int addressPort = ConfigUtils.getAddressPort(getApplicationContext());
        if (addressPort <= 0) {
            addressPort = AssetsConfigUtils.getInstance().getServerAddressPort();
        }
        return addressPort;
    }

    private void onConnectClick() {
        ViewUtils.hideInputWindowDelay(this);
        if (layoutAddress.getVisibility() == View.VISIBLE) {
            saveAddressPort();
        } else {
            saveIpAndPort();
        }
    }

    private void saveIpAndPort() {
        String ip = editText_ip.getText().toString();
        String port = editText_port.getText().toString();
        if (validateIP(ip) && validatePort(port)) {
            saveConfig(ip, port, "");
        } else {
            ToastUtils.makeText(this, R.string.sh_server_config_invalid, Toast.LENGTH_SHORT).show();
        }
    }

    private void saveAddressPort() {
        String address = editText_Address.getText().toString();
        String port = editText_Address_port.getText().toString();
        if (validateAddress(address) && validatePort(port)) {
            saveConfig("", port, address);
        } else {
            ToastUtils.makeText(this, R.string.sh_server_config_invalid, Toast.LENGTH_SHORT).show();
        }
    }

    private void saveConfig(String ip, String port, String address) {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_server_config_saving);
        new ServerConfigRepository().saveServerConfigAsync(this, ip, Integer.valueOf(port), address, new Consumer<Integer>() {
            @Override
            public void accept(Integer ret) throws Exception {
                finishLoadingDialog();
                if (ret == ErrorCode.RET_NET_EXCEPTION) {
                    showNetErrorDialog();
                    return;
                }
                if (ret != 0) {
                    Log.e("VhsmInit", "saveServerConfigAsync ret: " + ret);
                    String errMsg = getString(R.string.sh_server_config_save_fail, ret);
                    if (ret == DomainErrorCode.RET_SERVER_CONFIG_IP_ERROR) {
                        errMsg = getString(R.string.sh_server_config_error);
                    }

                    ToastUtils.makeText(ServerConfigActivity.this, errMsg, Toast.LENGTH_SHORT).show();
                    return;
                }
                //保存成功后，直接跳转到主界面
                ToastUtils.makeText(ServerConfigActivity.this, R.string.sh_server_config_save_success, Toast.LENGTH_SHORT).show();
                handleKeyBack();
                ServerConfigActivity.this.finish();
            }
        });
    }


    private boolean validatePort(String portStr) {
        if (TextUtils.isEmpty(portStr)) {
            showError(editText_port, "端口不能为空");
            return false;
        }

        int port = -1;
        try {
            port = Integer.valueOf(portStr);
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (port <= 0 || port > 65535) {
            showError(editText_port, "端口不符合要求");
            return false;
        }

        return true;
    }

    /**
     * 验证ip地址是否合法
     *
     * @param ip
     * @return
     */
    private boolean validateIP(String ip) {
        if (TextUtils.isEmpty(ip)) {
            showError(editText_ip, "ip地址不能为空");
            return false;
        }

        if (!FuncUtils.isValidIP(ip)) {
            showError(editText_ip, "ip地址不符合要求");
            return false;
        }
        return true;
    }

    private boolean validateAddress(String address) {
        if (TextUtils.isEmpty(address)) {
            showError(editText_Address, "域名地址不能为空");
            return false;
        }

        //add 2019年6月29日11:49:08 weizg
        if (address.toLowerCase().startsWith("http://")) {
            showError(editText_Address, "请删除http://");
            return false;
        }

        if (address.toLowerCase().startsWith("https://")) {
            showError(editText_Address, "请删除https://");
            return false;
        }

        return true;
    }

    /**
     * 显示错误提示，并获取焦点
     *
     * @param textInputLayout
     * @param error
     */
    private void showError(TextInputEditText textInputLayout, String error) {
        textInputLayout.setError(error);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        SPermission.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.d(tag, "onRequestPermissionsResult:" + requestCode);
    }

    private void requestPermission() {

        Log.d(tag, "requestPermission");

        SPermission.with(ServerConfigActivity.this)
                .setMOUDLE(2)
                .setmRequestCode(2)
                .setPermissions(new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE})
                .setmOnPermissionListener(new OnPermissionListener() {
                    @Override
                    public void onPermissionGranted() {
                    }

                    @Override
                    public void onPermissionDenied(String[] strings) {

                        Log.d(tag, "onPermissionDenied");

                        createCommonDialog(R.string.sh_getDevId_some_powers_has_forbid, R.string.sh_WRITE_EXTERNAL_STORAGE_has_forbid_content
                                , R.string.sh_cancel, R.string.sh_open_power, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        commonDialog.dismiss();
                                        ServerConfigActivity.this.finish();
                                    }
                                }, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        commonDialog.dismiss();

                                        SPermission.getsPermission().activeSPermission();
                                        requestPermission();
                                    }
                                });
                    }

                    @Override
                    public void onPermissionDeniedAlways(String[] strings) {
                        //权限被禁止以后不再询问
                        Log.d(tag, "onPermissionDeniedAlways");
                        //当点击禁止，并且不再提醒，则弹框提示用户去设置界面手动进行设置
                        createCommonDialog(R.string.sh_acu_can_not_open_power_title, R.string.sh_acu_can_not_open_power_content
                                , R.string.sh_cancel, R.string.sh_open_power
                                , new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        commonDialog.dismiss();

                                        ServerConfigActivity.this.finish();
                                    }
                                }
                                , new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        commonDialog.dismiss();
                                        FuncUtils.getAppDetailSettingIntent(ServerConfigActivity.this);
                                    }
                                });
                    }

                })
                .requestPermissions();

    }

    private boolean isGrantedPermission() {
        return ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE)
                == PackageManager.PERMISSION_GRANTED;
    }

    private AlertDialog commonDialog;

    private void createCommonDialog(int titleRes, int contentRes,
                                    int leftButtonRes, int rightButtonRes,
                                    DialogInterface.OnClickListener leftButtonListener,
                                    DialogInterface.OnClickListener rightButtonListener) {
        commonDialog = new AlertDialog.Builder(this)
                .setTitle(titleRes)
                .setMessage(contentRes)
                .setPositiveButton(rightButtonRes, rightButtonListener)
                .setNegativeButton(leftButtonRes, leftButtonListener)
                .create();
        commonDialog.setCanceledOnTouchOutside(false);
        commonDialog.setCancelable(false);
        commonDialog.show();
    }

    private void layoutConfigClick() {

        if (isShowIp){
            showAddress();
        }else {
            showIpAndPort();
        }

    }

    private boolean isShowIp = false;

    /**
     * 显示IP和端口号
     */
    private void showIpAndPort() {
        isShowIp = true;
        layoutIpPort.setVisibility(View.VISIBLE);
        layoutAddress.setVisibility(View.GONE);
        btnSetting.setText(R.string.sh_lable_address);
    }

    /**
     * 显示地址
     */
    private void showAddress() {
        isShowIp = false;
        layoutIpPort.setVisibility(View.GONE);
        layoutAddress.setVisibility(View.VISIBLE);
        btnSetting.setText(R.string.sh_lable_ip);

        //add 2019年6月29日17:05:01 weizg 如果当前没有地址信息，那么首先显示默认配置
        String strInEdit = editText_Address.getText().toString();
        if (TextUtils.isEmpty(strInEdit)) {
            editText_Address.setText(AssetsConfigUtils.getInstance().getServerAddress());
        }
    }
}
