package com.xdja.safehelper.activity;

import android.Manifest;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;


import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.initvhsm.net.bean.TypeStatus;
import com.xdja.initvhsm.net.bean.business.ApplyResult;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.initvhsm.net.bean.business.ApplyType;
import com.xdja.initvhsm.net.bean.business.ResetApplyBean;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;

import com.xdja.safehelper.R;


import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.vhsm.domain.VHSMBean;
import com.xdja.vhsm.domain.VHSMStatus;
import com.xdja.vhsm.mvp.presenter.VhsmInitPresenter;
import com.xdja.vhsm.net.BusinessRespAsync;
import com.xdja.vhsm.net.NetRespositoryASync;
import com.xdja.vhsm.permission.OnPermissionListener;
import com.xdja.vhsm.permission.SPermission;
import com.xdja.safehelper.update.Update;
import com.xdja.vhsm.utils.FuncUtils;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.vhsm.VhsmManager;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.InitFailDialog;
import com.xdja.safehelper.view.MyCustomDialog;

import java.util.ArrayList;

import io.reactivex.functions.Consumer;

public class VHSMMainActivity extends BaseActivity {

    private BusinessRespAsync businessRespAsync;
    private NetRespositoryASync netRespositoryASync;
    private boolean isFirst;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sh_vhsm_main);

        businessRespAsync = new BusinessRespAsync();
        netRespositoryASync = new NetRespositoryASync();
        isFirst = true;
        initView();
    }

    private View tv_refresh, img_setting;
    private TextView tv_cardId, tv_apply_status, tv_forgetPin;
    private Button btn_operate;


    private void initView() {
        initToolbar(false, R.string.sh_vhsm_manager);
        tv_refresh = findViewById(R.id.tv_refresh);
        tv_refresh.setVisibility(View.VISIBLE);
        tv_refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                requestPermissions();
            }
        });

        img_setting = findViewById(R.id.tar_img_setting);
        img_setting.setVisibility(View.VISIBLE);
        img_setting.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                gotoSetting();
            }
        });

        tv_cardId = findViewById(R.id.tv_cardId);

        tv_apply_status = findViewById(R.id.tv_apply_status);
        btn_operate = findViewById(R.id.btn_operate);
        tv_forgetPin = findViewById(R.id.tv_forgetPin);

        hideViews();
    }

    private void hideViews() {
        tv_apply_status.setVisibility(View.GONE);
        btn_operate.setVisibility(View.GONE);
        tv_forgetPin.setVisibility(View.GONE);
    }


    /**
     * 进入设置页面
     */
    private void gotoSetting() {
        startActivity(new Intent(this, SettingActivity.class));
    }

    /**
     * 刷新
     */
    private void doRefresh() {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            if (isFirst) {
                showNetError();
                isFirst = false;
            } else {
                showNetErrorDialog();
            }
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_device_status_loading);
        queryVHSMState();
    }


    @Override
    protected void onResume() {
        super.onResume();
        requestPermissions();
    }

    @Override
    protected void onPause() {
        super.onPause();
        SPermission.getsPermission().activeSPermission();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions,
                                           @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        SPermission.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.d(tag, "onRequestPermissionsResult:" + requestCode);
    }

    /**
     * 查询VHSM的状态
     */
    private void queryVHSMState() {
        businessRespAsync.queryVHSMState(new Consumer<VHSMBean>() {
            @Override
            public void accept(VHSMBean vhsmBean) throws Exception {
                showVHSMStatus(vhsmBean);
            }
        });
    }

    /**
     * Android10 升级弹框
     */
    private MyCustomDialog android10Dialog;

    private void showAndroid10Dialog() {
        if (android10Dialog == null) {
            String androidId = NetVhsmDeviceIdUtils.getAndroidID(this);
            String android10tip = getString(R.string.sh_android10_tip, androidId);
            SpannableStringBuilder style = new SpannableStringBuilder(android10tip);
            style.setSpan(new ForegroundColorSpan(getResources().getColor(R.color.sh_value_color)), android10tip.lastIndexOf("。") + 1, android10tip.length(), Spannable.SPAN_EXCLUSIVE_INCLUSIVE);
            android10Dialog = new MyCustomDialog.Builder(this)
                    .setSpannableMessage(style)
                    .setTextCenterHorizontal(false)
                    .setPositiveButton(R.string.sh_reinit, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            gotoVerifyPhone("");
                        }
                    })
                    .setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            VHSMMainActivity.this.finish();
                        }
                    })
                    .create();
            android10Dialog.setCancelable(false);
            android10Dialog.setCanceledOnTouchOutside(false);
        }
        if (android10Dialog.isShowing()) {
        }
        android10Dialog.show();
    }


    private void showVhsmOpenErrorDialog(int ret) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(this)
                .setMessage(getString(R.string.sh_android10_parse_error, ret))
                .setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        VHSMMainActivity.this.finish();
                    }
                }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    /**
     * 网络异常
     */
    private void showNetError() {
        hideViews();
        tv_apply_status.setVisibility(View.VISIBLE);
        tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        tv_apply_status.setTextColor(getResources().getColor(R.color.sh_modify_phone_text_color));
        SpannableString spannableString = new SpannableString(getString(R.string.sh_net_error1));
        spannableString.setSpan(new RelativeSizeSpan(1.0f), 0, 13, Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
        spannableString.setSpan(new RelativeSizeSpan(0.8f), 13, spannableString.length(), Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
        tv_apply_status.setText(spannableString);
    }


    private void showVHSMStatus(VHSMBean vhsmBean) {
        VHSMMainActivity.this.finishLoadingDialog();
        //网络不存在
        if (vhsmBean.vhsmStatus == ErrorCode.RET_NET_EXCEPTION) {
            if (isFirst) {
                showNetError();
                isFirst = false;
            } else {
                showNetErrorDialog();
            }
            return;
        }
        switch (vhsmBean.vhsmStatus) {
            case VHSMStatus.VHSM_DEVID_GIBBERISH:
                showNotifyDialog(R.string.sh_device_id_gibberish);
                break;
            case VHSMStatus.VHSM_STOPPED:
                showNotifyDialog(R.string.sh_device_is_stopped);
                break;
            case VHSMStatus.VHSM_LOGOFF:
                showNotifyDialog(R.string.sh_device_is_logoff);
                break;
            case VHSMStatus.VHSM_NORMAL_WITHOUT_BIND:
                showNotifyDialog(R.string.sh_device_is_invalid);
                break;
            case ErrorCode.RET_COMPANY_DISABLE:
                showNotifyDialog(R.string.sh_company_disable);
                break;
            case VHSMStatus.VHSM_OK:
                showViewVhsmOK();
                break;
            case VHSMStatus.VHSM_NOT_REGIST:
//                showViewStatus(vhsmBean);
//                break;
            case VHSMStatus.VHSM_NOT_INITIAL:
//                showViewStatus(vhsmBean);
//                break;

            case VHSMStatus.VHSM_FILE_NOT_EXISTS:
//                showViewStatus(vhsmBean);
//                break;
            case VHSMStatus.VHSM_LOCKED:
                showViewStatus(vhsmBean);
                break;
            case VHSMStatus.VHSM_RESET_PIN:
                showViewResetPin(vhsmBean);
                break;
            case VHSMStatus.VHSM_ANDROID10_UPDATE:
                showAndroid10Dialog();
                break;
            default:
                if (vhsmBean.isOpenVHSMError) {
                    showVhsmOpenErrorDialog(vhsmBean.vhsmStatus);
                } else {
                    Toast.makeText(VHSMMainActivity.this,
                            ErrorMatcher.getErrorMsg(vhsmBean.vhsmStatus), Toast.LENGTH_SHORT).show();
                }
                break;
        }
        Update.getInstance().checkUpdate(this, false);
    }


    /**
     * 展示弹框
     *
     * @param res
     */
    private void showNotifyDialog(@StringRes int res) {
        DialogRepository.showNotifyDialog(this, getString(res), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VHSMMainActivity.this.finish();
            }
        });
    }

    /**
     * 展示未初始化 或 未注册时的界面
     */
    private void showNotInitialView(final int vhsmStatus) {
        hideViews();
        showVHSM();

        btn_operate.setVisibility(View.VISIBLE);
        btn_operate.setText(R.string.sh_to_use);
        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                toUse(vhsmStatus);
            }
        });
    }


    private void showViewResetPin(VHSMBean bean) {
        showViewVhsmOK();
        if (bean.applyStatus == ApplyStatus.STATUS_NOT_APPROVAL) {  //未审核
            tv_forgetPin.setText(getString(R.string.sh_forget_pin_status, "待审批"));
        } else if (bean.applyStatus == ApplyStatus.STATUS_AGREE) {//审核通过
            tv_forgetPin.setText(getString(R.string.sh_forget_pin_status, "已同意"));
        } else if (bean.applyStatus == ApplyStatus.STATUS_REGECT) { //拒绝
            tv_forgetPin.setText(R.string.sh_forget_pin);
            showResetPinRejectDialog();
        }
    }

    /**
     * 重置Pin申请
     */
    private void resetPinApply() {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_dev_reset_apply_loading);
        netRespositoryASync.resetPinApply(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (integer != 0) {

                    if (integer == ErrorCode.RET_NET_EXCEPTION) {
                        showNetErrorDialog();
                    } else if (integer == ErrorCode.RET_NET_DEVICE_DISABLE) {
                        showNotifyDialog(R.string.sh_device_is_stopped);
                    } else if (integer == ErrorCode.RET_COMPANY_DISABLE) {
                        showNotifyDialog(R.string.sh_company_disable);
                    } else {
                        Toast.makeText(VHSMMainActivity.this,
                                ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(VHSMMainActivity.this, R.string.sh_dev_reset_already_apply, Toast.LENGTH_SHORT).show();
                    doRefresh();
                }

            }
        });
    }

    /**
     * 重置Pin申请
     */
    private void queryResetPinApplyStatus() {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_dev_regist_apply_loading);
        businessRespAsync.queryResetPinApplyStatus(new Consumer<ResetApplyBean>() {
            @Override
            public void accept(ResetApplyBean resetApplyBean) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                showResetPinApplyResult(resetApplyBean.status);
            }
        });
    }


    private void showResetPinApplyResult(int status) {
        if (status == ResetApplyBean.STATUS_OK) {
        } else if (status == ResetApplyBean.STATUS_DEVICE_LOGOFF) {
            showNotifyDialog(R.string.sh_device_is_stopped);
        } else if (status == ResetApplyBean.STATUS_REINIT_NOT_COMPLETE) {
            Toast.makeText(VHSMMainActivity.this,
                    getString(R.string.sh_reinit_apply_tobe_approval), Toast.LENGTH_SHORT).show();
        } else if (status == ResetApplyBean.STATUS_RESET_APPLY_NOT_APPLY) {
            showResetPinNotification();
        } else if (status == ResetApplyBean.STATUS_RESET_APPLY_FOR_APPROVAL) {
            showForApprovalDialog(VHSMStatus.VHSM_RESET_PIN);
        } else if (status == ResetApplyBean.STATUS_RESET_APPLY_AGREE) {
            resetPin();
        } else if (status == ResetApplyBean.STATUS_RESET_APPLY_REJECT) {
            tv_forgetPin.setText(R.string.sh_forget_pin);
            showResetPinRejectDialog();
        } else if (status == ErrorCode.RET_COMPANY_DISABLE) {
            showNotifyDialog(R.string.sh_company_disable);
        } else if (status == ErrorCode.RET_NET_EXCEPTION) {
            showNetErrorDialog();
        } else {
            Toast.makeText(VHSMMainActivity.this,
                    ErrorMatcher.getErrorMsg(status), Toast.LENGTH_SHORT).show();
        }
    }


    private void resetPin() {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_dev_reset_loading);
        netRespositoryASync.resetPin(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (integer == 0) {
                    showViewVhsmOK();
                    showResetPINApplyAgreeDialog();
                } else if (integer == ErrorCode.RET_NET_EXCEPTION) {
                    showNetErrorDialog();
                } else if (integer == ErrorCode.RET_COMPANY_DISABLE) {
                    showNotifyDialog(R.string.sh_company_disable);
                } else {
                    Toast.makeText(VHSMMainActivity.this, ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    /**
     * 展示重置Pin申请被拒绝
     */
    private void showResetPinRejectDialog() {
        DialogRepository.showNotifyDialog(this, getString(R.string.sh_dev_reset_apply_reject), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                sendRejectRequest(ApplyType.TYPE_RESET_PIN);
                dialog.dismiss();
            }
        });
    }


    private void toUse(int vhsmStatus) {
        if (vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //未初始化
            doInit();
        } else { //未注册，且没有注册申请
            gotoVerifyPhone("");
        }
    }


    /**
     * 初始化
     */
    private int num;

    private void doInit() {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_dev_init_loading);
        netRespositoryASync.init(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (integer == 0) {
                    showViewVhsmOK();
                    Toast.makeText(VHSMMainActivity.this, VHSMMainActivity.this.getString(R.string.sh_dev_init_success), Toast.LENGTH_SHORT).show();
                } else if (integer == ErrorCode.RET_NET_EXCEPTION) {
                    showNetErrorDialog();
                } else if (integer == ErrorCode.RET_UNBIND_PERSON) {
                    gotoVerifyPhone("");
                } else if (integer == ErrorCode.RET_DEVICE_ACHIVE_MAX || integer == ErrorCode.RET_LICENSE_MAX_DEVICE) {
                    Toast.makeText(VHSMMainActivity.this, ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                } else if (integer == ErrorCode.RET_COMPANY_DISABLE) {
                    showNotifyDialog(R.string.sh_company_disable);
                } else {
                    if (num == 0) {
                        num++;
                        showFailDialog();
                    } else {
                        Toast.makeText(VHSMMainActivity.this, ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                    }
                }
            }
        });
    }

    private InitFailDialog initFailDialog;

    private void showFailDialog() {
        if (initFailDialog == null) {
            initFailDialog = new InitFailDialog(this);
            initFailDialog.setPositiveButton(new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            initFailDialog.setTimeInter(new InitFailDialog.TimeInter() {
                @Override
                public void timeOut() {
                    doInit();
                }
            });
        }
        initFailDialog.show();
        initFailDialog.startTimer();
    }


    /**
     * 展示VHSM正常界面
     */
    private void showViewVhsmOK() {
        hideViews();
        showCardId();
        tv_forgetPin.setVisibility(View.VISIBLE);
        tv_forgetPin.setText(R.string.sh_forget_pin);
        tv_forgetPin.setTextColor(getResources().getColor(R.color.sh_single_btn_normal));
        tv_forgetPin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                queryResetPinApplyStatus();
            }
        });
    }


    private void showResetPinNotification() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(this)
                .setMessage(R.string.sh_dev_reset_apply_notice)
                .setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                }).setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        resetPinApply();
                        dialog.dismiss();
                    }
                }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    /**
     * 展示卡号
     */
    private void showCardId() {
        String cardId = VhsmManager.getInstance(this).getCardId();
        if (TextUtils.isEmpty(cardId)) {
            showVHSM();
        } else {
            tv_cardId.setVisibility(View.VISIBLE);
            tv_cardId.setTextColor(getResources().getColor(R.color.sh_cardId_color));
            tv_cardId.setTextSize(14);
            tv_cardId.setText(VhsmManager.getInstance(this).getCardId());
            tv_cardId.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.sh_detail, 0);
            tv_cardId.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    startActivity(new Intent(VHSMMainActivity.this, DeviceInfoActivity.class));
                }
            });
        }

    }


    /**
     * 卡号位置展示 VHSM
     */
    private void showVHSM() {
        hideViews();
        tv_cardId.setVisibility(View.VISIBLE);
        tv_cardId.setText(R.string.sh_vhsm);
        tv_cardId.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        tv_cardId.setTextColor(getResources().getColor(R.color.sh_vhsm_color));
        tv_cardId.setTextSize(16);
    }


    private void showViewStatus(final VHSMBean bean) {
        hideViews();
        if (bean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || bean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //如果未注册或者 未初始化时，不展示卡号
            showVHSM();
        } else {
            showCardId();
        }

        if (bean.applyStatus == ApplyStatus.STATUS_NOT_APPLY || bean.applyStatus == ApplyStatus.STATUS_REGECT_SHOWED) { //未申请

            if (bean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || bean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //未注册
                showNotInitialView(bean.vhsmStatus);
            } else if (bean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) {//文件不存在
                showFileNotExistDialog(bean);
            } else {// 锁死 (bean.vhsmStatus == VHSMStatus.VHSM_LOCKED)
                showLockedDialog();
            }

        } else if (bean.applyStatus == ApplyStatus.STATUS_NOT_APPROVAL) {//未审批
            showReApplyView(bean);
            tv_apply_status.setVisibility(View.VISIBLE);
            tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            tv_apply_status.setTextColor(getResources().getColor(R.color.sh_single_btn_normal));
            if (bean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || bean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //未注册
                tv_apply_status.setText(R.string.sh_regist_apply_submit);
            } else if (bean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
                tv_apply_status.setText(R.string.sh_reinit_apply_submit);
                showFileNotExistsTip();
            } else { // 锁死 (bean.vhsmStatus == VHSMStatus.VHSM_LOCKED)
                tv_apply_status.setText(R.string.sh_unlock_apply_submit);
            }
        } else if (bean.applyStatus == ApplyStatus.STATUS_AGREE) {//已同意
            if (bean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
                showFileNotExistsTip();
            }
            showAgreeApplyView(bean);
        } else {    //已拒绝  bean.applyStatus == ApplyStatus.STATUS_REGECT
            if ((bean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || bean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL)) { //未注册
                showRejectApplyView(R.string.sh_regist_apply_deny, ApplyType.TYPE_PERSON_REGIST, bean);
            } else if (bean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) {//文件不存在
                showRejectApplyView(R.string.sh_reinit_apply_deny, ApplyType.TYPE_REINIT, bean);
                showFileNotExistsTip();
            } else {// 锁死 (bean.vhsmStatus == VHSMStatus.VHSM_LOCKED)
                showRejectApplyView(R.string.sh_unlock_apply_deny, ApplyType.TYPE_UNLOCK, bean);
            }
        }

    }


    private void showFileNotExistsTip() {
        tv_forgetPin.setVisibility(View.VISIBLE);
        tv_forgetPin.setText(R.string.sh_file_not_exists_tip);
        tv_forgetPin.setTextColor(getResources().getColor(R.color.sh_modify_phone_text_color));
    }

    /**
     * 请求被拒绝时展示
     *
     * @param str
     */
    private void showRejectApplyView(@StringRes int str, int applyType, VHSMBean vhsmBean) {
        tv_apply_status.setVisibility(View.VISIBLE);
        tv_apply_status.setTextColor(getResources().getColor(R.color.sh_deny_color));
        tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(R.drawable.sh_tan, 0, 0, 0);
        tv_apply_status.setText(str);
        showReApplyView(vhsmBean);
        sendRejectRequest(applyType);
    }

    /**
     * 已同意展示页面
     *
     * @param bean
     */
    private void showAgreeApplyView(final VHSMBean bean) {
        tv_apply_status.setVisibility(View.VISIBLE);
        tv_apply_status.setTextColor(getResources().getColor(R.color.sh_single_btn_normal));
        tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        String type;
        if (bean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || bean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) {
            type = "";
        } else if (bean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
            type = "重新初始化";
        } else { // 锁死 (bean.vhsmStatus == VHSMStatus.VHSM_LOCKED)
            type = "解锁";
        }
        tv_apply_status.setText(getString(R.string.sh_apply_agree, type));
        btn_operate.setVisibility(View.VISIBLE);
        if (TextUtils.isEmpty(type)) {
            btn_operate.setText(R.string.sh_next);
        } else {
            btn_operate.setText(type);
        }
        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (bean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || bean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) {
                    gotoVerifyPhone(bean.deviceInfo.mobile);
                } else if (bean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
                    showReInitApplyAgreeDialog();
                } else { // 锁死 (bean.vhsmStatus == VHSMStatus.VHSM_LOCKED)
                    unlock();
                }
            }
        });
    }

    /**
     * 拒绝状态回显
     */
    private void sendRejectRequest(int applyType) {
        if (!NetUtils.isNetworkConnected(this)) {
            return;
        }
        netRespositoryASync.sendRejectRequest(applyType, new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
            }
        });
    }

    /**
     * 展示重新申请按钮
     *
     * @param vhsmBean
     */
    private void showReApplyView(final VHSMBean vhsmBean) {
        btn_operate.setVisibility(View.VISIBLE);
        btn_operate.setText(R.string.sh_reApply);
        btn_operate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                reApply(vhsmBean);
            }
        });
    }


    private void gotoVerifyPhone(String mobile) {
        Intent intent = new Intent(this, VhsmBindActivity.class);
        intent.putExtra(VhsmInitPresenter.MOBILE, mobile);
        startActivity(intent);
    }


    private void requestPermissions() {
        SPermission.with(VHSMMainActivity.this)
                .setMOUDLE(2)
                .setmRequestCode(1)
                .setPermissions(new String[]{Manifest.permission.READ_PHONE_STATE, Manifest.permission.WRITE_EXTERNAL_STORAGE})
                .setmOnPermissionListener(new OnPermissionListener() {
                    @Override
                    public void onPermissionGranted() {
                        //获取到权限
                        doRefresh();
                    }

                    @Override
                    public void onPermissionDenied(String[] strings) {
                        showPermissionDeniedDialog();
                    }

                    @Override
                    public void onPermissionDeniedAlways(String[] strings) {
                        //权限被禁止以后不再询问
                        Log.d(tag, "onPermissionDeniedAlways");
                        //当点击禁止，并且不再提醒，则弹框提示用户去设置界面手动进行设置
                        showPermissionDeniedAlwaysDialog();
                    }

                })
                .requestPermissions();

    }

    /**
     * 锁死弹框
     */
    private void showLockedDialog() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(this)
                .setMessage(R.string.sh_locked_dialog_msg)
                .setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        unlockApply();
                    }
                })
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }


    /**
     * 解锁申请 已同意弹框
     */
    private void showResetPINApplyAgreeDialog() {
        DialogRepository.showTwoBtnDialog(this, getString(R.string.sh_reset_apply_agree_dialog_msg), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
    }


    /**
     * 重新初始化申请 已同意
     */
    private void showReInitApplyAgreeDialog() {
        DialogRepository.showTextCenterHorizontalTwoBtnDialog(this, getString(R.string.sh_reInit_apply_agree_dialog_msg), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                reInit();
            }
        });
    }


    /**
     * 重新初始化申请
     */
    private void reInitApply() {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_dev_reinit_apply_loading);
        netRespositoryASync.reInitApply(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {
                if (integer != 0) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    if (integer == ErrorCode.RET_NET_EXCEPTION) {
                        showNetErrorDialog();
                    } else if (integer == ErrorCode.RET_NET_DEVICE_DISABLE) {
                        showNotifyDialog(R.string.sh_device_is_stopped);
                    } else if (integer == ErrorCode.RET_COMPANY_DISABLE) {
                        showNotifyDialog(R.string.sh_company_disable);
                    } else {
                        Toast.makeText(VHSMMainActivity.this,
                                ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    VHSMBean vhsmBean = new VHSMBean();
                    vhsmBean.vhsmStatus = VHSMStatus.VHSM_FILE_NOT_EXISTS;
                    vhsmBean.applyStatus = ApplyStatus.STATUS_NOT_APPROVAL;
                    showVHSMStatus(vhsmBean);
                }
            }
        });
    }

    private void reInit() {

        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }

        if (isShowDialog()) {
            return;
        }

        showLoadingDialog(R.string.sh_dev_reinit_loading);
        businessRespAsync.reInit(new Consumer<Integer>() {
            @Override
            public void accept(Integer ret) throws Exception {
                if (ret == 0) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    Toast.makeText(VHSMMainActivity.this, getString(R.string.sh_dev_reinit_success), Toast.LENGTH_SHORT).show();
                    showViewVhsmOK();
                } else if (ret == ErrorCode.RET_NET_EXCEPTION) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    showNetErrorDialog();
                } else if (ret == ErrorCode.RET_COMPANY_DISABLE) {
                    showNotifyDialog(R.string.sh_company_disable);
                } else {
                    //add 2019年5月20日10:04:18 weizg
                    //如果重新初始化失败，则重新查询了当前状态，目的是确定按钮功能：是执行重新初始化流程还是跳转到提交重新初始化申请界面
                    queryVHSMState();
                    Toast.makeText(VHSMMainActivity.this, ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }


    /**
     * 解锁 申请（不需查询 申请状态）
     */
    private void unlockApply() {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }
        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_dev_unlock_apply_loading);
        netRespositoryASync.unlockApply(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) throws Exception {

                if (integer != 0) {
                    VHSMMainActivity.this.finishLoadingDialog();
                    if (integer == ErrorCode.RET_NET_EXCEPTION) {
                        showNetErrorDialog();
                    } else if (integer == ErrorCode.RET_NET_DEVICE_DISABLE) {
                        showNotifyDialog(R.string.sh_device_is_stopped);
                    } else if (integer == ErrorCode.RET_COMPANY_DISABLE) {
                        showNotifyDialog(R.string.sh_company_disable);
                    } else {
                        Toast.makeText(VHSMMainActivity.this,
                                ErrorMatcher.getErrorMsg(integer), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    queryVHSMState();
                }

            }
        });
    }

    /**
     * 解锁
     */
    private void unlock() {

        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }

        if (isShowDialog()) {
            return;
        }

        showLoadingDialog(R.string.sh_dev_unlock_loading);
        businessRespAsync.unlock(new Consumer<ApplyResult>() {
            @Override
            public void accept(ApplyResult applyResult) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                if (applyResult.status == 0) {
                    showViewVhsmOK();
                    showResetPINApplyAgreeDialog();
                    VhsmManager.getInstance(VHSMMainActivity.this).verifyPin(VhsmManager.DEFAULT_PIN_ROLE, "111111");
                } else if (applyResult.status == ErrorCode.RET_NET_EXCEPTION) {
                    showNetErrorDialog();
                } else if (applyResult.status == ErrorCode.RET_COMPANY_DISABLE) {
                    showNotifyDialog(R.string.sh_company_disable);
                } else {
                    Toast.makeText(VHSMMainActivity.this, ErrorMatcher.getErrorMsg(applyResult.status), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    /**
     * 文件缺失弹框
     */
    private void showFileNotExistDialog(final VHSMBean vhsmBean) {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(this)
                .setMessage(R.string.sh_file_not_exist_dialog_msg)
                .setPositiveButton(R.string.sh_submit_apply, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        reInitApply();
                    }
                })
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }


    /**
     * 点击重试
     *
     * @param vhsmBean
     */
    private void reApply(final VHSMBean vhsmBean) {
        if (!NetUtils.isNetworkConnected(this)) {
            //如果当前无可用网络
            showNetErrorDialog();
            return;
        }

        if (isShowDialog()) {
            return;
        }
        showLoadingDialog(R.string.sh_dev_regist_apply_loading);
        netRespositoryASync.queryApplyStatus(new Consumer<Pair<Integer, ArrayList<TypeStatus>>>() {
            @Override
            public void accept(Pair<Integer, ArrayList<TypeStatus>> integerArrayListPair) throws Exception {
                VHSMMainActivity.this.finishLoadingDialog();
                int status = integerArrayListPair.first;
                if (status == ErrorCode.RET_NET_EXCEPTION) {
                    showNetErrorDialog();
                } else if (status == 0) {
                    int applyType;
                    if (vhsmBean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || vhsmBean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //未注册
                        applyType = ApplyType.TYPE_PERSON_REGIST;
                    } else if (vhsmBean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
                        applyType = ApplyType.TYPE_REINIT;
                    } else { // 锁死 (bean.vhsmStatus == VHSMStatus.VHSM_LOCKED)
                        applyType = ApplyType.TYPE_UNLOCK;
                    }
                    for (TypeStatus typeStatus : integerArrayListPair.second) {

                        if (typeStatus.type == applyType) {
                            vhsmBean.applyStatus = typeStatus.status;
                            break;
                        }
                    }

                    if (vhsmBean.vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || vhsmBean.vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //未注册
                        reApplyRegist(vhsmBean);
                    } else if (vhsmBean.vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
                        reApplyReInit(vhsmBean);
                    } else { // 锁死 (bean.vhsmStatus == VHSMStatus.VHSM_LOCKED)
                        reApplyUnlock(vhsmBean);
                    }

                } else {
                    Toast.makeText(VHSMMainActivity.this,
                            ErrorMatcher.getErrorMsg(status), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }


    private void reApplyRegist(VHSMBean vhsmBean) {
        if (vhsmBean.applyStatus == ApplyStatus.STATUS_AGREE) {
            gotoVerifyPhone(vhsmBean.deviceInfo.mobile);
        } else if (vhsmBean.applyStatus == ApplyStatus.STATUS_NOT_APPROVAL) {
            showForApprovalDialog(VHSMStatus.VHSM_NOT_REGIST);
        } else {
            gotoVerifyPhone("");
        }
    }

    private void reApplyReInit(VHSMBean vhsmBean) {
        if (vhsmBean.applyStatus == ApplyStatus.STATUS_AGREE) {
            showReInitApplyAgreeDialog();
        } else if (vhsmBean.applyStatus == ApplyStatus.STATUS_NOT_APPROVAL) {
            showForApprovalDialog(VHSMStatus.VHSM_FILE_NOT_EXISTS);
        } else {
            reInitApply();
        }
    }


    private void reApplyUnlock(VHSMBean vhsmBean) {
        if (vhsmBean.applyStatus == ApplyStatus.STATUS_AGREE) {
            unlock();
        } else if (vhsmBean.applyStatus == ApplyStatus.STATUS_NOT_APPROVAL) {
            showForApprovalDialog(VHSMStatus.VHSM_LOCKED);
        } else {
            unlockApply();
        }
    }


    private void showForApprovalDialog(final int vhsmStatus) {
        String msg;
        if (vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //未注册
            msg = "人员注册";
        } else if (vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
            msg = "重新初始化";
        } else if (vhsmStatus == VHSMStatus.VHSM_LOCKED) {// 锁死
            msg = "解锁";
        } else {   //重置Pin
            msg = "忘记PIN码的";
        }

        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(this)
                .setMessage(getString(R.string.sh_dev_apply_submit, msg))
                .setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                })
                .setPositiveButton(R.string.sh_apply_again, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        if (vhsmStatus == VHSMStatus.VHSM_NOT_REGIST || vhsmStatus == VHSMStatus.VHSM_NOT_INITIAL) { //未注册
                            gotoVerifyPhone("");
                        } else if (vhsmStatus == VHSMStatus.VHSM_FILE_NOT_EXISTS) { //文件不存在
                            reInitApply();
                        } else if (vhsmStatus == VHSMStatus.VHSM_LOCKED) {// 锁死
                            unlockApply();
                        } else {   //重置Pin
                            resetPinApply();
                        }

                    }
                }).create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    /**
     * 展示 权限申请被拒绝 提示
     */
    private void showPermissionDeniedDialog() {
        createCommonDialog(R.string.sh_getDevId_some_powers_has_forbid, R.string.sh_getDevId_some_powers_has_forbid_content
                , R.string.sh_cancel, R.string.sh_open_power, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                        commonDialog.dismiss();
                        VHSMMainActivity.this.finish();
                    }
                }, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        commonDialog.dismiss();
                        SPermission.getsPermission().activeSPermission();
                        requestPermissions();
                    }
                });
    }

    private AlertDialog commonDialog;

    private void createCommonDialog(int titleRes, int contentRes,
                                    int leftButtonRes, int rightButtonRes,
                                    DialogInterface.OnClickListener leftButtonListener,
                                    DialogInterface.OnClickListener rightButtonListener) {
        commonDialog = new AlertDialog.Builder(this)
                .setTitle(titleRes)
                .setMessage(contentRes)
                .setPositiveButton(rightButtonRes, rightButtonListener)
                .setNegativeButton(leftButtonRes, leftButtonListener)
                .create();
        commonDialog.setCanceledOnTouchOutside(false);
        commonDialog.setCancelable(false);
        commonDialog.show();
    }


    /**
     * 展示 拒绝权限访问提示 弹框
     */
    private void showPermissionDeniedAlwaysDialog() {
        createCommonDialog(R.string.sh_acu_can_not_open_power_title, R.string.sh_acu_can_not_open_power_content1
                , R.string.sh_cancel, R.string.sh_acu_can_not_open_power_right_button
                , new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        commonDialog.dismiss();
                        VHSMMainActivity.this.finish();
                    }
                }
                , new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        commonDialog.dismiss();
                        FuncUtils.getAppDetailSettingIntent(VHSMMainActivity.this);
                    }
                });
    }


}
