package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.view.View;

import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.utils.ViewUtils;

/**
 * Created by hyh on 2020/4/8.
 */
public abstract class DefaultToolbarListener implements ToolbarListener {

    @Override
    public boolean isShowToolbar() {
        return true;
    }

    @Override
    public boolean isSupportLeftBack() {
        return true;
    }

    @Override
    public void leftClickListener() {
        handleKeyBack();
    }

    @Override
    public void rightSetClickListener() {

    }

    @Override
    public int rightSetIconResId() {
        return 0;
    }

    @Override
    public void rightClickListener() {

    }

    @Override
    public int rightTitleResId() {
        return 0;
    }

    @Override
    public void initToolbar(View rootView) {
        ToolbarWrapper toolbarWrapper = new ToolbarWrapper();
        toolbarWrapper.initToolbar(this, rootView);
    }

    public void handleKeyBack() {
        if (ViewUtils.isKeyboardShown(getContext())) {
            ViewUtils.hideInputWindowDelay(getContext());
        } else {
            ((Activity) getContext()).finish();
        }
    }
}
