package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;

import com.xdja.initvhsm.net.bean.DeviceInfo;
import com.xdja.safehelper.R;
import com.xdja.vhsm.bean.IdentifyItem;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.IdentifyInfoPresenter;
import com.xdja.safehelper.view.IdentifyAdapter;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by hyh on 2020/4/14.
 */
public class IdentifyInfoView extends AbstractCommonView<IdentifyInfoPresenter> {

    public static String PERSON_INFO = "PERSON_INFO";

    private DeviceInfo deviceInfo;

    RecyclerView recyclerView;

    @Override
    protected int getLayoutId() {
        return R.layout.sh_identify_info;
    }

    @Override
    protected void initContentView(View rootView) {
        recyclerView = rootView.findViewById(R.id.recyclerView);
    }

    @Override
    protected void bindContentViewEvent(View view) {

    }

    @Override
    public void onCreate(Activity context) {
        super.onCreate(context);
        deviceInfo = (DeviceInfo) getActivity().getIntent().getSerializableExtra(PERSON_INFO);
        showIdentify(deviceInfo);
    }


    private void showIdentify(DeviceInfo deviceInfo) {
        List<IdentifyItem> identifyItems = new ArrayList<>();
        identifyItems.add(getIdentifyItem(R.string.sh_bind_phone, deviceInfo.mobile));
        identifyItems.add(getIdentifyItem(R.string.sh_bind_name, deviceInfo.personName));
        //产品需求，隐藏
//        if (!TextUtils.isEmpty(deviceInfo.identity)) {
//            identifyItems.add(getIdentifyItem(R.string.sh_bind_id, deviceInfo.identity));
//        }
//
//        if (!TextUtils.isEmpty(deviceInfo.deptName)) {
//            identifyItems.add(getIdentifyItem(R.string.sh_bind_union, deviceInfo.deptName));
//        }


        IdentifyAdapter identifyAdapter = new IdentifyAdapter(identifyItems);
        identifyAdapter.initRecyclerView(recyclerView, getActivity());
    }


    private IdentifyItem getIdentifyItem(@StringRes int key, String value) {
        IdentifyItem identifyItem = new IdentifyItem();
        identifyItem.key = getActivity().getString(key);
        identifyItem.value = value;
        return identifyItem;
    }

    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return IdentifyInfoView.this.getActivity();
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_identify_info;
            }
        };
    }

    @Override
    public IdentifyInfoPresenter binderPresenter() {
        return new IdentifyInfoPresenter();
    }
}
