package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.CountDownTimer;
import android.support.annotation.StringRes;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.safehelper.R;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.mvp.common.AbstractCommonView;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.OperateWithCodePresenter;
import com.xdja.vhsm.mvp.view.OperateWithCodeViewBase;
import com.xdja.vhsm.utils.NetUtils;
import com.xdja.safehelper.view.DialogRepository;
import com.xdja.safehelper.view.LoadingDialog;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.VerificationAction;
import com.xdja.safehelper.view.VerificationCodeEditText;

public class OperateWithCodeView extends AbstractCommonView<OperateWithCodePresenter> implements OperateWithCodeViewBase<OperateWithCodePresenter> {


    @Override
    protected int getLayoutId() {
        return R.layout.sh_layout_verify_code_next;
    }


    private TextView tv_tip, tv_send_code, tv_code_tip, tv_retry, mobile_tip;
    private VerificationCodeEditText et_verify_code;
    private LoadingDialog loadingDialog;


    @Override
    protected void initContentView(View rootView) {
        tv_tip = rootView.findViewById(R.id.tv_tip);
        tv_send_code = rootView.findViewById(R.id.tv_send_code);
        tv_code_tip = rootView.findViewById(R.id.tv_code_tip);
        tv_retry = rootView.findViewById(R.id.tv_retry);
        mobile_tip = rootView.findViewById(R.id.mobile_tip);
        et_verify_code = rootView.findViewById(R.id.et_verify_code);
        loadingDialog = new LoadingDialog(getActivity());
    }


    public static final String TAG_MOBILE = "tag_mobile";
    public static final String TAG_OPERATE = "tag_operate";
    public static final String UNLOCK = "unlock";
    public static final String REINIT = "reinit";
    public static final String RESETPIN = "resetpin";
    private String mobile, operate;


    @Override
    protected void bindContentViewEvent(View view) {

        mobile = getActivity().getIntent().getStringExtra(TAG_MOBILE);
        operate = getActivity().getIntent().getStringExtra(TAG_OPERATE);

        tv_tip.setText(R.string.sh_verify_mobile_by_code);
        showMobile(mobile);

        tv_code_tip.setVisibility(View.INVISIBLE);
        tv_retry.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                sendCode();
            }
        });

        String str_mobile_tip = getActivity().getString(R.string.sh_mobile_not_use);
        SpannableStringBuilder spaString = getSpaString(str_mobile_tip, str_mobile_tip.indexOf("？") + 1, str_mobile_tip.length());
        mobile_tip.setText(spaString);
        mobile_tip.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showModifyMobileDialog();
            }
        });

        et_verify_code.setOnVerificationCodeChangedListener(new VerificationAction.OnVerificationCodeChangedListener() {
            @Override
            public void onVerCodeChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void onInputCompleted(CharSequence s) {
                hideKeyBoard();
                doNext(operate, s.toString(), mobile);
            }
        });


    }


    @Override
    public void onCreate(Activity context) {
        super.onCreate(context);
        sendCode();
    }

    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return getActivity();
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_verify_mobile;
            }
        };
    }


    private void showMobile(String mobile) {
        this.mobile = mobile;
        tv_send_code.setText(getActivity().getString(R.string.sh_code_to_mobile, mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2")));
    }

    private void doNext(String operate, String code, String mobile) {
        if (!NetUtils.isNetworkConnected(getActivity())) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(getActivity());
            return;
        }
        if (loadingDialog.isShowing()) {
            return;
        }
        if (operate.equals(UNLOCK)) {
            loadingDialog.showLoading(R.string.sh_loading_unlock);
            bindPresenter.unlockByCode(code, mobile);
        } else if (operate.equals(REINIT)) {
            loadingDialog.showLoading(R.string.sh_loading_reinit);
            bindPresenter.reInitByCode(code, mobile);
        } else {
            loadingDialog.showLoading(R.string.sh_loading_resetpin);
            bindPresenter.resetPinByCode(code, mobile);
        }
    }

    /**
     * 设置部分字体颜色的色值
     *
     * @param str
     * @param start
     * @param end
     */
    private SpannableStringBuilder getSpaString(String str, int start, int end) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        sb.append(str);
        ForegroundColorSpan span = new ForegroundColorSpan(getActivity().getResources().getColor(R.color.sh_single_btn_normal));
        sb.setSpan(span, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return sb;
    }

    /**
     * 展示修改手机号弹框
     */
    private void showModifyMobileDialog() {
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(getActivity())
                .setMessage(R.string.sh_modify_mobile)
                .setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                })
                .setTextCenterHorizontal(true)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }


    private void sendCode() {
        if (!NetUtils.isNetworkConnected(getActivity())) {
            //如果当前无可用网络
            DialogRepository.showNetErrorDialog(getActivity());
            return;
        }
        bindPresenter.getMobileAndCode();
        tv_code_tip.setVisibility(View.INVISIBLE);
        startTimer();
        showKeyBoard();
    }

    private CountDownTimer timer;
    private int TIME = 60;

    /**
     * 开始倒计时
     */
    private void startTimer() {
        showTimeLeftView(TIME);
        timer = new CountDownTimer(TIME * 1000, 1000) {
            public void onTick(long millisUntilFinished) {
                if (millisUntilFinished > 1000) {
                    showTimeLeftView(millisUntilFinished / 1000);
                } else {
                    cancelTimer();
                }
            }

            public void onFinish() {

            }
        };
        //调用 CountDownTimer 对象的 start() 方法开始倒计时，也不涉及到线程处理
        timer.start();
    }

    /**
     * 结束倒计时
     */
    private void cancelTimer() {
        if (timer == null) {
            return;
        }
        timer.cancel();
        showReSendView();
    }

    /**
     * 展示倒计时
     *
     * @param left
     */
    private void showTimeLeftView(long left) {
        tv_retry.setEnabled(false);
        String time = getActivity().getString(R.string.sh_time_left, left);
        tv_retry.setTextColor(getActivity().getResources().getColor(R.color.sh_cardId_color));
        tv_retry.setText(time);
    }


    private void showReSendView() {
        tv_retry.setEnabled(true);
        tv_retry.setTextColor(getActivity().getResources().getColor(R.color.sh_vhsm_text_color));
        tv_retry.setText(R.string.sh_re_send);
    }

    @Override
    public void showViewAfterSendCode(int ret, String mobile) {
        if (ret == 0) {
            showMobile(mobile);
        } else if (ret == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(getActivity());
        } else {
            ToastUtils.makeText(getActivity(),
                    ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void showViewAfterResetPin(int ret) {
        showViewAfterCode(ret, R.string.sh_resetpin_by_code_success);
    }

    @Override
    public void showViewAfterUnlock(int ret) {
        showViewAfterCode(ret, R.string.sh_unlock_by_code_success);
    }


    private void showViewAfterCode(int ret, @StringRes int strRes) {
        loadingDialog.finishLoadingDialog();
        if (ret == 0) {
            showOperateSuccessDialog(strRes);
        } else if (ret == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(getActivity());
        } else if (ret == ErrorCode.RET_CODE_INVALID || ret == ErrorCode.RET_CODE_ERROR) { //验证码错误
            tv_code_tip.setVisibility(View.VISIBLE);
            et_verify_code.clearComposingText();
        } else {
            ToastUtils.makeText(getActivity(),
                    ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
        }
    }


    private void showOperateSuccessDialog(@StringRes int resStr) {
        String str = getActivity().getString(resStr);
        SpannableStringBuilder spaString = getSpaString(str, str.indexOf("1"), str.lastIndexOf("1") + 1);
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(getActivity())
                .setSpannableMessage(spaString)
                .setPositiveButton(R.string.sh_confirm, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        getActivity().finish();
                    }
                })
                .setTextCenterHorizontal(true)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
    }

    @Override
    public void showViewAfterReInit(int ret) {
        showViewAfterCode(ret, R.string.sh_reinit_by_code_success);
    }

    @Override
    public OperateWithCodePresenter binderPresenter() {
        return new OperateWithCodePresenter();
    }


    private void showKeyBoard() {
        getActivity().getWindow().getDecorView().postDelayed(new Runnable() {
            @Override
            public void run() {
                et_verify_code.requestFocus();
                et_verify_code.setSelection(et_verify_code.getText().length());
                et_verify_code.toggleSoftInput(et_verify_code.getContext());
            }
        }, 300);
    }

    private void hideKeyBoard() {
        et_verify_code.toggleSoftInput(et_verify_code.getContext());
    }
}
