package com.xdja.safehelper.activity.view;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.airbnb.lottie.LottieAnimationView;
import com.xdja.safehelper.view.SHItemDecoration;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.VerifyPinDialog;
import com.xdja.vhsm.bean.CheckItemInfo;
import com.xdja.vhsm.mvp.common.ToolbarListener;
import com.xdja.vhsm.mvp.presenter.SelfCheckPresenter;
import com.xdja.vhsm.mvp.view.SelfCheckViewBase;
import com.xdja.safehelper.view.SelfCheckAdapter;

/**
 * Created by hyh on 2020/4/15.
 */
public class SelfCheckView extends SelfCheckViewBase<SelfCheckPresenter> {

    private RecyclerView mRecyclerView;
    private SelfCheckAdapter adapter;
    private TextView textCheckStatus;

    private LottieAnimationView animStatus;

    @Override
    protected int getLayoutId() {
        return R.layout.sh_activity_self_check;
    }

    @Override
    protected void initContentView(View rootView) {

        textCheckStatus = rootView.findViewById(R.id.text_check_status);
        animStatus = rootView.findViewById(R.id.image_status);

        mRecyclerView = rootView.findViewById(R.id.recyclerView);
        mRecyclerView.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
        mRecyclerView.setItemAnimator(new DefaultItemAnimator());
        mRecyclerView.addItemDecoration(new SHItemDecoration(getActivity(), (int) getActivity().getResources().getDimension(R.dimen.base_24)));
        adapter = new SelfCheckAdapter();
        mRecyclerView.setAdapter(adapter);
    }

    @Override
    protected void bindContentViewEvent(View view) {

    }

    @Override
    public void onCreate(Activity context) {
        super.onCreate(context);
        showVerifyPinDialog();

    }

    VerifyPinDialog dialog = null;

    private void showVerifyPinDialog() {
        if (dialog == null) {

            dialog = new VerifyPinDialog(getActivity());
            dialog.show();
            dialog.setCallBack(new VerifyPinDialog.CallBack() {
                @Override
                public void okCallBack(String pin) {
                    startCheck(pin);
                }

                @Override
                public void cancelCallBack() {
                    dialog.dismiss();
                    getActivity().finish();
                }
            });
        }

    }


    private void startCheck(String pin) {
        adapter.clear();
        if (!isNetworkConnected()) {
            if (dialog != null) {
                dialog.setVerifyPinErrorInfo(getActivity().getString(R.string.sh_activity_self_check_net_is_not_connect));
            }
            return;
        }
        dialog.dismiss();
        status = 0;
        checkIngAnim();
        bindPresenter.startCheck(pin);
    }

    /**
     * 状态。
     * 用于在检测过程中记录是否正常，有问题等状态。
     * 当检测结束时，如果为0，则最后在状态中显示 检测完成；
     * 如果为负数，则在最后状态中检测有问题。
     * 如果为正数，则在最后状态中显示失败。
     */
    private int status = 0;

    @Override
    public void checkNextCallback(CheckItemInfo info) {
        if (getActivity().isFinishing() || getActivity().isDestroyed()) return;
        if (info.tag.equals("openCard")) {
            dismissVerifyPinDialog();
        }
        if (!info.isContinue) {
            status = 1;
            checkFailAnim();
        } else if (info.ret != 0) {
            checkProblemAnim();
            status = -1;
        }
        showCheckInfo(info);
    }

    @Override
    public void completeCheck() {
        showCheckCompleteStatus();
    }

    private void showCheckInfo(CheckItemInfo info) {
        adapter.addInfo(info);
    }


    private void checkIngAnim() {
        showCheckIngStatus();
        if (!animStatus.isAnimating()) {
            animStatus.setImageAssetsFolder("images/");
            animStatus.setAnimation("sh_checking.json");
            animStatus.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            animStatus.playAnimation();
        }
    }

    private void showCheckIngStatus() {
        String src = getActivity().getString(R.string.sh_activity_self_check_ing);
        textCheckStatus.setText(src);

    }

    private int problemNum = 0;

    private void checkProblemAnim() {
        problemNum++;
        if (!animStatus.isAnimating() || status >= 0) {
            if (animStatus.isAnimating()) {
                animStatus.clearAnimation();
            }
            animStatus.setImageAssetsFolder("images/");
            animStatus.setAnimation("sh_check_problem.json");
            animStatus.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            animStatus.playAnimation();
        }
        String src = getActivity().getString(R.string.sh_activity_self_check_problem);
        textCheckStatus.setText(String.format(src, problemNum));
    }

    private void checkFailAnim() {
        if (animStatus.isAnimating()) {
            animStatus.clearAnimation();
        }
        animStatus.setImageAssetsFolder("images/");
        animStatus.setAnimation("sh_check_fail.json");
        animStatus.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        animStatus.loop(false);
        animStatus.playAnimation();
    }

    private void showCheckCompleteStatus() {
        String info = "";
        if (status == 0) {
            info = getActivity().getString(R.string.sh_activity_self_check_ok);
        } else if (status < 0) {
            String src = getActivity().getString(R.string.sh_activity_self_check_problem);
            info = String.format(src, problemNum);
        } else if (status > 0) {
            info = getActivity().getString(R.string.sh_activity_self_check_fail);
        }
        textCheckStatus.setText(info);
        animStatus.loop(false);
    }

    private boolean isNetworkConnected() {
        ConnectivityManager mConnectivityManager = (ConnectivityManager) getActivity().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
        if (mNetworkInfo != null) {
            return mNetworkInfo.isAvailable();
        }
        return false;
    }

    private void dismissVerifyPinDialog() {
        if (dialog != null) {
            dialog.dismiss();
            dialog = null;
        }
    }

    private void showMsg(final String msg) {
        getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ToastUtils.makeText(getActivity().getApplicationContext(), msg, Toast.LENGTH_LONG).show();
            }
        });
    }

    @Override
    protected ToolbarListener getToolbarListener() {
        return new DefaultToolbarListener() {
            @Override
            public Context getContext() {
                return SelfCheckView.this.getActivity();
            }

            @Override
            public int leftTitleResId() {
                return R.string.sh_activity_self_check_title;
            }
        };
    }

    @Override
    public SelfCheckPresenter binderPresenter() {
        return new SelfCheckPresenter();
    }


}
