package com.xdja.safehelper.activity.view.handle;

import android.app.Activity;
import android.content.DialogInterface;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * android10升级，管理员审批模式
 * <p>
 * 都不显示
 * 直接弹窗提示，弹窗暂不支持
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class Android10UpdateNoApplyHandle implements HandleMain {
    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_ANDROID10_UPDATE &&
                vhsmBean.verifyTypeBean != null && vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_APPROVAL &&
                (vhsmBean.applyStatus.deviceRegisterApply == ApplyStatus.STATUS_NOT_APPLY || vhsmBean.applyStatus.deviceRegisterApply == ApplyStatus.STATUS_REGECT_SHOWED)) {
            return true;
        }
        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        view.hideViews();
        final Activity activity = view.getActivity();
        String androidId = NetVhsmDeviceIdUtils.getAndroidID(activity.getApplicationContext());
        String android10tip = activity.getString(R.string.sh_android10_tip, androidId);
        SpannableStringBuilder style = new SpannableStringBuilder(android10tip);
        style.setSpan(new ForegroundColorSpan(activity.getResources().getColor(R.color.sh_value_color)), android10tip.lastIndexOf("。") + 1, android10tip.length(), Spannable.SPAN_EXCLUSIVE_INCLUSIVE);
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                .setSpannableMessage(style)
                .setTextCenterHorizontal(false)
                .setPositiveButton(R.string.sh_reinit, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        //目前暂不支持
                        ToastUtils.makeText(activity.getApplicationContext(), R.string.sh_fun_not_support, Toast.LENGTH_SHORT).show();
                    }
                })
                .setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        activity.finish();
                    }
                })
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
        view.setShowingDialog(myCustomDialog);
    }
}
