package com.xdja.safehelper.activity.view.handle;

import android.app.Activity;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.VhsmBindActivity;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * Android10升级情况，短信处理
 * 都不显示，主动弹窗提示
 * 弹窗按钮跳转到 人员注册界面
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class Android10UpdateSmsHandle implements HandleMain {
    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_ANDROID10_UPDATE &&
                vhsmBean.verifyTypeBean != null && vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_SMS) {
            return true;
        }
        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        view.hideViews();
        final Activity activity = view.getActivity();
        String androidId = NetVhsmDeviceIdUtils.getAndroidID(activity.getApplicationContext());
        String android10tip = activity.getString(R.string.sh_android10_tip, androidId);
        SpannableStringBuilder style = new SpannableStringBuilder(android10tip);
        style.setSpan(new ForegroundColorSpan(activity.getResources().getColor(R.color.sh_value_color)), android10tip.lastIndexOf("。") + 1, android10tip.length(), Spannable.SPAN_EXCLUSIVE_INCLUSIVE);
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                .setSpannableMessage(style)
                .setTextCenterHorizontal(false)
                .setPositiveButton(R.string.sh_reinit, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        Intent intent = new Intent(activity, VhsmBindActivity.class);
                        activity.startActivity(intent);
                    }
                })
                .setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        activity.finish();
                    }
                })
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();
        view.setShowingDialog(myCustomDialog);
    }

}
