package com.xdja.safehelper.activity.view.handle;

import android.content.DialogInterface;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.OperateWithCodeView;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * 文件缺失，短信审批。
 * 都不显示，主动弹窗。
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/20 <br/>
 */
public class FileLostSmsHandle  implements HandleMain {
    private String mobile;

    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        //服务端状态是正常或已就绪，但本地状态是文件缺失，同时审批方式是短信
        if (HandleUtils.isFileLost(vhsmBean) &&
                vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_FILE_LOST &&
                vhsmBean.verifyTypeBean != null &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_SMS) {
            mobile = vhsmBean.verifyTypeBean.mobile;
            return true;
        }
        return false;
    }

    @Override
    public void handle(final VHSMMainViewNew view) {
        view.hideViews();

        int msg = R.string.sh_file_not_exist_dialog_msg_code;
        int btn_text = R.string.sh_submit_verify;

        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(view.getActivity())
                .setMessage(msg)
                .setPositiveButton(btn_text, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        view.gotoVerifyActivity(mobile,OperateWithCodeView.REINIT);
                    }
                })
                .setTextCenterHorizontal(true)
                .create();
        myCustomDialog.setCancelable(false);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();

        view.setShowingDialog(myCustomDialog);
    }
}
