package com.xdja.safehelper.activity.view.handle;

import com.xdja.initvhsm.net.bean.business.ApplyStatus;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/20 <br/>
 */
public class HandleUtils {

    /**
     * 是否是文件缺失
     *
     * @param vhsmBean
     * @return
     */
    public static boolean isFileLost(VhsmBean vhsmBean) {
        if (isNormalOrReady(vhsmBean) &&
                vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_FILE_LOST) {
            return true;
        }
        return false;
    }

    /**
     * 是否是正常或已就绪
     *
     * @param vhsmBean
     * @return
     */
    public static boolean isNormalOrReady(VhsmBean vhsmBean) {
        int status = vhsmBean.vhsmServerStatus;
        if (status == VhsmStatus.VHSM_SERVER_READY || status == VhsmStatus.VHSM_SERVER_NORMAL) {
            return true;
        }
        return false;
    }

    /**
     * 是否是未申请或申请已拒绝
     *
     * @param whichStatus
     * @return
     */
    public static boolean isNotApplyOrShowedReject(int whichStatus) {
        if (whichStatus == ApplyStatus.STATUS_NOT_APPLY || whichStatus == ApplyStatus.STATUS_REGECT_SHOWED) {
            return true;
        }
        return false;
    }
}
