package com.xdja.safehelper.activity.view.handle;

import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * 非法状态。（已就绪/正常状态下，无人员信息）
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/20 <br/>
 */
public class IllegalStateHandle implements HandleMain {
    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if ((vhsmBean.vhsmServerStatus == VhsmStatus.VHSM_SERVER_NORMAL || vhsmBean.vhsmServerStatus == VhsmStatus.VHSM_SERVER_READY)
                && vhsmBean.deviceInfo.personId == null) {
            return true;
        }
        return false;
    }

    @Override
    public void handle(VHSMMainViewNew view) {
        view.hideViews();
        view.showNotifyDialog(R.string.sh_device_is_invalid);
    }
}
