package com.xdja.safehelper.activity.view.handle;

import android.app.Activity;
import android.content.DialogInterface;
import android.view.View;
import android.widget.TextView;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.OperateWithCodeView;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * 正常状态，短信方式
 * 卡号显示，
 * 状态不显示，
 * 按钮不显示，
 * 忘记PIN码显示，点击跳转到验证页面,
 * 不弹窗
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class NormalSmsHandle implements HandleMain {
    private String mobile;

    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_NORMAL &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_SMS) {
            mobile = vhsmBean.verifyTypeBean.mobile;
            return true;
        }
        return false;
    }

    @Override
    public void handle(final VHSMMainViewNew view) {
        view.hideViews();
        view.showCardId();
        final Activity activity = view.getActivity();
        TextView tv_forgetPin = view.getTv_forgetPin();
        tv_forgetPin.setVisibility(View.VISIBLE);
        tv_forgetPin.setText(R.string.sh_forget_pin);
        tv_forgetPin.setTextColor(activity.getResources().getColor(R.color.sh_single_btn_normal));
        tv_forgetPin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int msg = R.string.sh_dev_reset_apply_notice_code;
                int btn_text = R.string.sh_submit_verify;
                MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                        .setMessage(msg)
                        .setNegativeButton(R.string.sh_cancel, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        }).setPositiveButton(btn_text, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                view.gotoVerifyActivity(mobile, OperateWithCodeView.RESETPIN);
                            }
                        }).create();
                myCustomDialog.setCancelable(false);
                myCustomDialog.setCanceledOnTouchOutside(false);
                myCustomDialog.show();
                view.setShowingDialog(myCustomDialog);
            }
        });
    }
}
