package com.xdja.safehelper.activity.view.handle;

import android.app.Activity;
import android.content.DialogInterface;
import android.view.View;
import android.widget.TextView;

import com.xdja.initvhsm.net.bean.GetVerifyTypeBean;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.OperateWithCodeView;
import com.xdja.safehelper.activity.view.VHSMMainViewNew;
import com.xdja.safehelper.view.MyCustomDialog;
import com.xdja.vhsm.bean.VhsmBean;
import com.xdja.vhsm.bean.VhsmStatus;

/**
 * PIN码锁死，短信处理
 * 卡号显示，
 * 状态显示PIN码锁死，
 * 按钮显示，
 * 忘记PIN码不显示，
 * 主动弹窗提示，点击按钮结束弹窗
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2020/4/21 <br/>
 */
public class PinLockedSmsHandle implements HandleMain {
    private String mobile;

    @Override
    public boolean canHandle(VhsmBean vhsmBean) {
        if (vhsmBean.vhsmLocalStatus == VhsmStatus.VHSM_LOCAL_LOCKED &&
                vhsmBean.verifyTypeBean.verify == GetVerifyTypeBean.TYPE_SMS) {
            mobile = vhsmBean.verifyTypeBean.mobile;
            return true;
        }
        return false;
    }

    @Override
    public void handle(final VHSMMainViewNew view) {
        final Activity activity = view.getActivity();

        view.hideViews();
        view.showCardId();

        TextView tv_apply_status = view.getTv_apply_status();
        tv_apply_status.setVisibility(View.VISIBLE);
        tv_apply_status.setTextColor(activity.getResources().getColor(R.color.sh_deny_color));
        tv_apply_status.setCompoundDrawablesWithIntrinsicBounds(R.drawable.sh_tan, 0, 0, 0);
        tv_apply_status.setText(R.string.sh_chip_locked);

        int msg = R.string.sh_locked_dialog_msg_code;
        int btn_text = R.string.sh_submit_verify;
        MyCustomDialog myCustomDialog = new MyCustomDialog.Builder(activity)
                .setMessage(msg)
                .setPositiveButton(btn_text, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        view.gotoVerifyActivity(mobile, OperateWithCodeView.UNLOCK);
                    }
                })
                .setTextCenterHorizontal(true)
                .create();
        myCustomDialog.setCancelable(true);
        myCustomDialog.setCanceledOnTouchOutside(false);
        myCustomDialog.show();

        view.setShowingDialog(myCustomDialog);
    }
}
