package com.xdja.safehelper.error;

import android.util.SparseIntArray;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.safehelper.R;
import com.xdja.vhsm.utils.ContextCache;


public class ErrorMatcher {
    private static SparseIntArray ERROR;

    static {
        ERROR = new SparseIntArray();
        ERROR.put(ErrorCode.RET_NET_INIT_ERROR, R.string.sh_init_fail);
        ERROR.put(ErrorCode.RET_NET_DATA_LEN_ERROR, R.string.sh_data_len_error);
        ERROR.put(ErrorCode.RET_NET_PARAM_ERROR, R.string.sh_paras_error);

        ERROR.put(ErrorCode.RET_NET_VERIFY_PIN_ERROR, R.string.sh_pin_verify_error);
        ERROR.put(ErrorCode.RET_NET_SM2PRI_DEC_ERROR, R.string.sh_sms_dec_error);

        ERROR.put(ErrorCode.RET_BADCERT_ERROR, R.string.sh_cert_error);

        ERROR.put(ErrorCode.RET_NET_UNKONW_DATA, R.string.sh_msg_error);
        ERROR.put(ErrorCode.RET_NET_UNKONW_DEVICE, R.string.sh_dev_not_reg);
        ERROR.put(ErrorCode.RET_NET_DEVICE_NOT_INIT, R.string.sh_dev_not_init);
        ERROR.put(ErrorCode.RET_NET_DEVICE_LOCK, R.string.sh_dev_locked);
        ERROR.put(ErrorCode.RET_NET_DEVICE_DISABLE, R.string.sh_dev_stopped);
        ERROR.put(ErrorCode.RET_NET_DEVICE_EXIST, R.string.sh_dev_exist);
        ERROR.put(ErrorCode.RET_NET_APPLY_INVALID, R.string.sh_apply_invalid);
        ERROR.put(ErrorCode.RET_DEVICE_ACHIVE_MAX, R.string.sh_liscence_outof_num_1);
        ERROR.put(ErrorCode.RET_SAFE_KEY_ERROR, R.string.sh_cert_service_error);
        ERROR.put(ErrorCode.RET_DELETEED_DEVICE, R.string.sh_dev_is_logoff);

        ERROR.put(ErrorCode.RET_UNKONW_MOBILE, R.string.sh_unknown_phone);
        ERROR.put(ErrorCode.RET_CODE_INVALID, R.string.sh_verify_code_invalid);
        ERROR.put(ErrorCode.RET_CODE_ERROR, R.string.sh_verify_code_error);
        ERROR.put(ErrorCode.RET_HMACSHA_ERROR, R.string.sh_comp_sign_error);
        ERROR.put(ErrorCode.RET_BIND_ERROR, R.string.sh_bind_error);
        ERROR.put(ErrorCode.RET_SMS_ERROR, R.string.sh_msg_inter_err);
        ERROR.put(ErrorCode.RET_UNBIND_PERSON, R.string.sh_unbind_person);
        ERROR.put(ErrorCode.RET_PERSON_EXIST, R.string.sh_person_eixst);
        ERROR.put(ErrorCode.RET_PERSON_NOT_EXIST, R.string.sh_person_not_eixst);
        ERROR.put(ErrorCode.RET_LICENSE_MAX_DEVICE, R.string.sh_liscence_outof_num_2);
        ERROR.put(ErrorCode.RET_MOBILE_EXIST, R.string.sh_phone_exist);
        ERROR.put(ErrorCode.RET_IDENTITY_EXIST, R.string.sh_identify_exist);
        ERROR.put(ErrorCode.RET_BIND_PERSON, R.string.sh_bind_person);
        ERROR.put(ErrorCode.RET_IDENTIFY_ERROR, R.string.sh_identify_error);
        ERROR.put(ErrorCode.RET_SINGLE, R.string.sh_single_error);
        ERROR.put(ErrorCode.RET_COMPANY_DISABLE, R.string.sh_company_disable);
        ERROR.put(ErrorCode.RET_COMPANY_NOT_EXIST, R.string.sh_company_not_exist);
        ERROR.put(ErrorCode.RET_MOBILE_MODIFY, R.string.sh_mobile_modify);
        ERROR.put(ErrorCode.RET_EXCEPTION, R.string.sh_exception);
    }

    /**
     * 根据错误码获取错误信息
     *
     * @param code
     * @return
     */
    public static String getErrorMsg(int code) {
        if (ERROR.indexOfKey(code) < 0) {
            return null;
        }
        return ContextCache.getContext().getString(ERROR.get(code));
    }
}
