package com.xdja.safehelper.module.changepin;

import android.content.Context;
import android.util.Pair;

import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.vhsm.mvp.presenter.ChangePinPresenter;

/**
 * Created by hyh on 2020/4/15.
 */
public class SHChangePinApply implements ChangePinPresenter.IChangePinApply {

    final int role = 0x11;

    @Override
    public int apply(Context context, String oldPin, String newPin) {
        Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, JniApiParam.TYPE_VHSM_NET);
        if (make.first != 0) {
            return make.first;
        }
        JarJniApiProxy second = make.second;
        return second.ChangePIN(role, oldPin.getBytes(), oldPin.length(), newPin.getBytes(), newPin.length());
    }
}
