package com.xdja.safehelper.module.changepin;

import android.app.Activity;
import android.widget.Toast;
import com.xdja.safehelper.R;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.safehelper.view.LoadingDialog;

/**
 * Created by hyh on 2020/4/15.
 */
public class SHChangePinResultCallback implements ConsumerCallback<Integer> {

    private LoadingDialog loadingDialog;

    private Activity activity;

    public SHChangePinResultCallback(Activity activity) {
        loadingDialog = new LoadingDialog(activity);
        loadingDialog.showLoading(R.string.sh_change_pin_loading);
        this.activity = activity;
    }

    @Override
    public void resultCallback(Integer ret) {
        if (activity.isFinishing() || activity.isDestroyed())
            return;
        loadingDialog.finishLoadingDialog();
        showChangePinResult(ret);
    }

    private void showChangePinResult(int ret) {
        if (ret < 0) {
            if (ret == -10 || ret == -16) {
                ToastUtils.makeText(this.activity, R.string.sh_chip_locked, Toast.LENGTH_LONG).show();
            } else {
                ToastUtils.makeText(this.activity, this.activity.getString(R.string.sh_change_pin_error, ret), Toast.LENGTH_LONG).show();
            }
        } else if (ret == 0) {
            ToastUtils.makeText(this.activity, this.activity.getString(R.string.sh_change_pin_success), Toast.LENGTH_LONG).show();
            this.activity.finish();
        } else if (ret < 6) {
            ToastUtils.makeText(this.activity, this.activity.getString(R.string.sh_pin_error_left_time, ret), Toast.LENGTH_LONG).show();
        } else {
            ToastUtils.makeText(this.activity, R.string.sh_pin_error, Toast.LENGTH_LONG).show();
        }
    }
}
