package com.xdja.safehelper.module.setting;

import android.content.Intent;
import android.text.TextUtils;
import android.util.Pair;
import android.widget.Toast;

import com.xdja.initvhsm.net.bean.DeviceInfo;
import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.initvhsm.net.bean.business.DeviceStatus;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.DeviceInfoActivity;
import com.xdja.safehelper.activity.IdentifyInfoActivity;
import com.xdja.safehelper.activity.view.IdentifyInfoView;
import com.xdja.safehelper.activity.view.SettingView;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.safehelper.view.DialogRepository;

/**
 * Created by hyh on 2020/4/13.
 */
public class SHQueryDeviceResultCallback implements ConsumerCallback<Pair<Integer, DeviceInfo>> {

    private SettingView settingView;

    private Class enterClass;

    public SHQueryDeviceResultCallback(SettingView settingView, Class enterClass) {
        this.settingView = settingView;
        this.enterClass = enterClass;
    }

    @Override
    public void resultCallback(Pair<Integer, DeviceInfo> ret) {
        if (settingView.getActivity().isFinishing() || settingView.getActivity().isDestroyed())
            return;
        this.settingView.finishLoadingDialog();
        int result = ret.first;
        if (result == 0) {
            if (enterClass == IdentifyInfoActivity.class) {
                showIdentify(ret.second);
            } else if (enterClass == DeviceInfoActivity.class) {
                showDeviceInfo(ret.second);
            }
        } else if (result == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(this.settingView.getActivity());
        } else {
            String errorInf = ErrorMatcher.getErrorMsg(result);
            if (!TextUtils.isEmpty(errorInf)) {
                ToastUtils.makeText(this.settingView.getActivity(), errorInf, Toast.LENGTH_SHORT).show();
            }

        }
    }

    private void showIdentify(DeviceInfo deviceInfo) {
        if (deviceInfo.personId == null && deviceInfo.deviceUnbindEnable == 1) { //设备不需要绑人
            ToastUtils.makeText(settingView.getActivity(), R.string.sh_get_identify_nothing, Toast.LENGTH_LONG).show();
            return;
        }
        if (deviceInfo.personId == null && deviceInfo.deviceUnbindEnable == 0) { //设备需要绑人，但未绑人
            ToastUtils.makeText(settingView.getActivity(), R.string.sh_get_identify_info_not_regist, Toast.LENGTH_LONG).show();
            return;
        }

        if ((deviceInfo.status == DeviceStatus.DEVICE_STATUS_READY || deviceInfo.status == DeviceStatus.DEVICE_STATUS_NORMAL) && deviceInfo.personId == null) { //设备已注册或可以正常，但未与人有绑定关系
            ToastUtils.makeText(settingView.getActivity(), R.string.sh_device_is_invalid, Toast.LENGTH_LONG).show();
            return;
        }

        if (deviceInfo == null) {
            ToastUtils.makeText(settingView.getActivity(), R.string.sh_get_identify_nothing, Toast.LENGTH_LONG).show();
            return;
        }
        Intent intent = new Intent(settingView.getActivity(), IdentifyInfoActivity.class);
        intent.putExtra(IdentifyInfoView.PERSON_INFO, deviceInfo);
        settingView.getActivity().startActivity(intent);
    }

    private void showDeviceInfo(DeviceInfo deviceInfo) {
        if (deviceInfo.status == DeviceStatus.DEVICE_STATUS_REGISTER) {
            ToastUtils.makeText(settingView.getActivity(), R.string.sh_devinfo_not_init, Toast.LENGTH_SHORT).show();

        }
        Intent intent = new Intent(settingView.getActivity(), DeviceInfoActivity.class);
        settingView.getActivity().startActivity(intent);
    }

}
