package com.xdja.safehelper.module.setting;

import android.content.Intent;
import android.view.View;

import com.xdja.safehelper.activity.view.SettingView;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.ChangePinActivity;
import com.xdja.safehelper.activity.DeviceInfoActivity;
import com.xdja.safehelper.activity.IdentifyInfoActivity;
import com.xdja.safehelper.activity.SelfCheckActivity;
import com.xdja.safehelper.activity.ServerConfigActivity;
import com.xdja.vhsm.bean.SettingItemInfo;
import com.xdja.safehelper.update.Update;
import com.xdja.vhsm.utils.AssetsConfigUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by hyh on 2020/4/13.
 */
public class SHSettingItemData {
    private SettingView settingView;

    public SHSettingItemData(SettingView settingView) {
        this.settingView = settingView;
    }

    public List<SettingItemInfo> getSettingItemInfo() {
        List<SettingItemInfo> settingItemInfoList = new ArrayList<>();
        SettingItemInfo idInfo = new SettingItemInfo();
        idInfo.info = settingView.getActivity().getString(R.string.sh_setting_id_info);
        idInfo.iconRes = R.drawable.sh_ic_item_idinfo;
        idInfo.listener = personListener;
        settingItemInfoList.add(idInfo);

        SettingItemInfo deviceInfo = new SettingItemInfo();
        deviceInfo.info = settingView.getActivity().getString(R.string.sh_setting_device_info);
        deviceInfo.iconRes = R.drawable.sh_ic_item_device;
        deviceInfo.listener = deviceInfoListener;
        settingItemInfoList.add(deviceInfo);

        SettingItemInfo checkAbility = new SettingItemInfo();
        checkAbility.info = settingView.getActivity().getString(R.string.sh_setting_check_ability);
        checkAbility.iconRes = R.drawable.sh_ic_item_checkability;
        checkAbility.listener = create(SelfCheckActivity.class);
        settingItemInfoList.add(checkAbility);


        SettingItemInfo changePin = new SettingItemInfo();
        changePin.info = settingView.getActivity().getString(R.string.sh_setting_change_pin);
        changePin.listener = changePinListener;
        changePin.iconRes = R.drawable.sh_ic_item_change_pin;
        settingItemInfoList.add(changePin);


        SettingItemInfo checkNew = new SettingItemInfo();
        checkNew.info = settingView.getActivity().getString(R.string.sh_setting_check_new);
        checkNew.listener = updateListener;
        checkNew.iconRes = R.drawable.sh_ic_item_update;
        settingItemInfoList.add(checkNew);


        boolean isConfigServer = AssetsConfigUtils.getInstance().getDefaultConfigServerFlag();
        if (isConfigServer) {
            SettingItemInfo addressConfig = new SettingItemInfo();
            addressConfig.info = settingView.getActivity().getString(R.string.sh_setting_address_config);
            addressConfig.listener = create(ServerConfigActivity.class);
            settingItemInfoList.add(addressConfig);
        }
        return settingItemInfoList;
    }

    private View.OnClickListener personListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {
            settingView.requestDeviceInfo(IdentifyInfoActivity.class);
        }
    };
    private View.OnClickListener deviceInfoListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            settingView.requestDeviceInfo(DeviceInfoActivity.class);
        }
    };

    private View.OnClickListener create(final Class intoClass) {
        return new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(settingView.getActivity(), intoClass);
                settingView.getActivity().startActivity(intent);
            }
        };
    }

    private View.OnClickListener changePinListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            Intent intent = new Intent(settingView.getActivity(), ChangePinActivity.class);
            settingView.getActivity().startActivity(intent);
        }
    };


    /**
     * 检测更新点击事件
     */
    private View.OnClickListener updateListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            Update.getInstance().checkUpdate(settingView.getActivity(), true);
        }
    };

}
