package com.xdja.safehelper.module.vhsmbind;

import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.safehelper.R;
import com.xdja.safehelper.activity.view.VhsmInitView;
import com.xdja.safehelper.error.ErrorMatcher;
import com.xdja.safehelper.view.ToastUtils;
import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.safehelper.view.DialogRepository;


/**
 * Created by hyh on 2020/4/13.
 */
public class SHBindPersonResultCallback implements ConsumerCallback<Integer> {
    private VhsmInitView vhsmInitView;

    public SHBindPersonResultCallback(VhsmInitView vhsmInitView) {
        this.vhsmInitView = vhsmInitView;
    }

    @Override
    public void resultCallback(Integer ret) {
        if (vhsmInitView.getActivity().isFinishing() || vhsmInitView.getActivity().isDestroyed())
            return;
        if (ret != 0) {
            vhsmInitView.dismissLoadingDialog();
            if (ret == ErrorCode.RET_NET_EXCEPTION) {
                DialogRepository.showNetErrorDialog(vhsmInitView.getActivity());
            } else if (ret == ErrorCode.RET_CODE_INVALID || ret == ErrorCode.RET_CODE_ERROR) {//验证码失效 或者错误
                ToastUtils.makeText(vhsmInitView.getActivity(), R.string.sh_code_invalid, Toast.LENGTH_SHORT).show();
            } else {
                ToastUtils.makeText(vhsmInitView.getActivity(), ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
            }
        } else {
            vhsmInitView.initVhsm();
        }
    }
}
