package com.xdja.safehelper.module.vhsmbind;

import android.widget.Toast;

import com.xdja.initvhsm.net.bean.ErrorCode;
import com.xdja.safehelper.activity.view.VhsmInitView;
import com.xdja.safehelper.R;


import com.xdja.safehelper.error.ErrorMatcher;

import com.xdja.safehelper.view.ToastUtils;

import com.xdja.vhsm.mvp.presenter.ConsumerCallback;
import com.xdja.safehelper.view.DialogRepository;

/**
 * Created by hyh on 2020/4/13.
 */
public class SHGetCodeResultCallback implements ConsumerCallback<Integer> {

    private VhsmInitView vhsmInitView;

    public SHGetCodeResultCallback(VhsmInitView vhsmInitView) {
        this.vhsmInitView = vhsmInitView;
    }


    @Override
    public void resultCallback(Integer ret) {
        if (vhsmInitView.getActivity().isFinishing() || vhsmInitView.getActivity().isDestroyed())
            return;
        if (ret != 0) {
            vhsmInitView.codeSendCallback();
        }
        if (ret == 0) {
            ToastUtils.makeText(vhsmInitView.getActivity(), R.string.sh_code_send_sucess, Toast.LENGTH_SHORT).show();
        } else if (ret == ErrorCode.RET_NET_EXCEPTION) {
            DialogRepository.showNetErrorDialog(vhsmInitView.getActivity());
        } else if (ret == ErrorCode.RET_UNKONW_MOBILE) {
            vhsmInitView.showIdentifyDialog();
        } else if (ret == ErrorCode.RET_SINGLE) {
            vhsmInitView.showDialogAboutSingle();
        } else if (ret == ErrorCode.RET_COMPANY_DISABLE) {
            vhsmInitView.showNotifyDialog(R.string.sh_company_disable);
        } else {
            ToastUtils.makeText(vhsmInitView.getActivity(), ErrorMatcher.getErrorMsg(ret), Toast.LENGTH_SHORT).show();
        }
    }
}
