package com.xdja.safehelper.view;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.widget.TextView;

import com.xdja.safehelper.R;


/**
 * loading 对话框
 * Created by guoyaxin on 2016/9/2.
 */
public class LoadingDialog extends SafeHelperCommonDialog {

    private Activity activity;

    private boolean isVerticalLayout;

    public LoadingDialog(Context context) {
        super(context);
        this.activity = (Activity) context;
    }

    private TextView tv_content;

    public void setVerticalLayout(boolean verticalLayout) {
        isVerticalLayout = verticalLayout;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        tv_content = findViewById(R.id.tv_content);
        tv_content.setText(this.content);
        setCanceledOnTouchOutside(false);
        setCancelable(false);
    }

    @Override
    public int getLayoutId() {
        if (isVerticalLayout) {
            return R.layout.sh_loading_dialog_vertical;
        }
        return R.layout.sh_loading_dialog;
    }


    private String content = "";

    public void setContent(String content) {
        if (TextUtils.isEmpty(content))
            return;
        if (tv_content != null) {
            tv_content.setText(content);
        } else {
            this.content = content;
        }
    }

    /**
     * 展示弹框
     *
     * @param msgRes
     */
    public void showLoading(@StringRes int msgRes) {
        if (isShowing() || this.activity.isFinishing()) {
            return;
        }
        setContent(getContext().getString(msgRes));
        show();
    }

    /**
     * 取消弹框
     */
    public void finishLoadingDialog() {
        if (isShowing()) {
            try {
                dismiss();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
