package com.xdja.safehelper.view;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;

import com.xdja.safehelper.R;

public class ProgressBarDialog extends SafeHelperCommonDialog {
    public ProgressBarDialog(Context context) {
        super(context);
    }

    private ProgressBar progress_bar;
    private Button btn_positive;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        progress_bar = findViewById(R.id.progress_bar);

        btn_positive = findViewById(R.id.btn_positive);
        btn_positive.setText(R.string.sh_cancel);
        btn_positive.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (onClickListener != null) {
                    onClickListener.onClick(v);
                }
            }
        });
    }

    @Override
    public int getLayoutId() {
        return R.layout.sh_dialog_progressbar;
    }

    /**
     * 更新进度
     *
     * @param progress
     */
    public void updateProgress(int progress) {
        progress_bar.setProgress(progress);
    }

    private View.OnClickListener onClickListener;

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

}
