package com.xdja.safehelper.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.xdja.safehelper.R;

/**
 * Created by hyh on 2020/4/22.
 */
public class SHItemDecoration extends RecyclerView.ItemDecoration {
    private int mDividerHeight = 40;

    private Paint mPaint;

    private int left;


    public SHItemDecoration(Context context, int left) {
        mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint.setColor(Color.parseColor("#E3E2E3"));
        mPaint.setStrokeCap(Paint.Cap.ROUND);
        mDividerHeight = (int) context.getResources().getDimension(R.dimen.sh_decoration_height);
        this.left = left;
    }

    @Override
    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        drawHorizontalLine(c, parent, state);

    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.set(0, 0, 0, mDividerHeight);
    }

    private void drawHorizontalLine(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        canvas.save();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childAt = parent.getChildAt(i);
            int left = this.left;
            int right = parent.getWidth();
            int top = childAt.getBottom();
            int bottom = childAt.getBottom() + mDividerHeight;
            canvas.drawRect(left, top, right, bottom, mPaint);
        }
        canvas.restore();
    }

}
