package com.xdja.safehelper.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;

import com.xdja.safehelper.R;
/**
 * Created by hyh on 2020/4/9.
 */
public abstract class SafeHelperCommonDialog extends Dialog {
    private Activity activity;

    public SafeHelperCommonDialog(@NonNull Context context) {
        this(context, R.style.SafeHelperDialogTheme);
    }

    public SafeHelperCommonDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        activity = (Activity) context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(getLayoutId());
        initView();
    }

    public abstract int getLayoutId();

    public void initView() {

    }

    @Override
    public void show() {
        if (isShowing() || activity.isFinishing() || activity.isDestroyed()) {
            return;
        }
        super.show();
    }

    @Override
    public void dismiss() {
        if (!isShowing() || activity.isFinishing() || activity.isDestroyed()) {
            return;
        }
        super.dismiss();
    }
}
