package com.xdja.safehelper.view;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.xdja.safehelper.R;

/**
 * Created by guoyaxin on 2016/8/11.
 */
public class TitleAndContentDialog extends SafeHelperCommonDialog {

    public TitleAndContentDialog(Context context) {
        super(context);
    }

    private Builder builder;

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    @Override
    public int getLayoutId() {
        if (this.builder.negativeButtonText != null) {
            return R.layout.sh_update_dailog;
        }
        return R.layout.sh_force_update_dailog;
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (builder == null) {
            return;
        }

        if (!TextUtils.isEmpty(builder.title)) {
            TextView tv_title = findViewById(R.id.tv_title);
            tv_title.setText(builder.title);
        }

        if (!TextUtils.isEmpty(builder.message)) {
            TextView tv_content = findViewById(R.id.tv_content);
            tv_content.setText(builder.message);
        }

        if (!TextUtils.isEmpty(builder.positiveButtonText) && builder.positiveButtonClickListener != null) {
            Button btn_positive = findViewById(R.id.btn_positive);
            btn_positive.setText(builder.positiveButtonText);
            btn_positive.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    builder.positiveButtonClickListener.onClick(TitleAndContentDialog.this, BUTTON_POSITIVE);
                }
            });
        }

        if (!TextUtils.isEmpty(builder.negativeButtonText) && builder.negativeButtonClickListener != null) {
            Button btn_negative = findViewById(R.id.btn_negative);
            btn_negative.setText(builder.negativeButtonText);
            btn_negative.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    builder.negativeButtonClickListener.onClick(TitleAndContentDialog.this, BUTTON_POSITIVE);
                }
            });
        }
    }

    public static class Builder {

        private Context context;

        private OnClickListener positiveButtonClickListener;
        private OnClickListener negativeButtonClickListener;
        private String message = null;
        private String title = null;
        private String positiveButtonText = null;
        private String negativeButtonText = null;


        TextView tv_title;
        TextView tv_content;
        Button btn_negative;
        Button btn_positive;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setPositiveButton(String positiveButtonText, OnClickListener onClickListener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButtonText, OnClickListener onClickListener) {
            this.positiveButtonText = context.getString(positiveButtonText);
            this.positiveButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(String negativeButtonText, OnClickListener onClickListener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int negativeButtonText, OnClickListener onClickListener) {
            this.negativeButtonText = context.getString(negativeButtonText);
            this.negativeButtonClickListener = onClickListener;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int message) {
            this.message = context.getString(message);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            this.title = context.getString(title);
            return this;
        }

        public TitleAndContentDialog create() {
            final TitleAndContentDialog titleAndContentDialog = new TitleAndContentDialog(context);
            titleAndContentDialog.setBuilder(this);
            return titleAndContentDialog;
        }

    }

}
