package com.xdja.safehelper.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.xdja.safehelper.R;

/**
 * Created by hyh on 2020/4/24.
 */
public class VerifyPinDialog extends SafeHelperCommonDialog implements View.OnClickListener {

    private EditText editPinView;

    private TextView verifyPinErrorInfoView;

    private TextView verifyPinTitleView;

    private CallBack callBack;

    public VerifyPinDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.sh_dialog_verify_pin;
    }

    @Override
    public void initView() {
        super.initView();
        setCancelable(false);
        setCanceledOnTouchOutside(false);
        editPinView = findViewById(R.id.edit_input_pin);
        verifyPinErrorInfoView = findViewById(R.id.tv_verify_error_info);
        verifyPinTitleView = findViewById(R.id.tv_verify_pin_title);
        Button btnOk = findViewById(R.id.btn_positive);
        btnOk.setOnClickListener(this);
        btnOk.setText(R.string.sh_dialog_verify_pin_ok);

        Button btnCancel = findViewById(R.id.btn_negative);
        btnCancel.setOnClickListener(this);
        btnCancel.setText(R.string.sh_dialog_verify_pin_cancel);
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btn_positive) {
            btnOkClick();
        } else if (id == R.id.btn_negative) {
            btnCancelClick();
        }
    }

    public void setVerifyPinTitle(String title) {
        verifyPinTitleView.setText(title);
    }

    private void btnOkClick() {
        String pin = editPinView.getText().toString();
        verifyPinErrorInfoView.setVisibility(View.VISIBLE);
        if (TextUtils.isEmpty(pin)) {
            verifyPinErrorInfoView.setText(R.string.sh_dialog_verify_pin_null);
            return;
        }
        if (pin.length() < 6) {
            verifyPinErrorInfoView.setText(R.string.sh_dialog_verify_pin_short);
            return;
        }
        if (pin.length() > 16) {
            verifyPinErrorInfoView.setText(R.string.sh_dialog_verify_pin_long);
            return;
        }
        verifyPinErrorInfoView.setVisibility(View.GONE);
        if (callBack != null) {
            callBack.okCallBack(pin);
        }
    }

    public void setVerifyPinErrorInfo(String errorInfo) {
        verifyPinErrorInfoView.setVisibility(View.VISIBLE);
        verifyPinErrorInfoView.setText(errorInfo);
    }

    public void setCallBack(CallBack callBack) {
        this.callBack = callBack;
    }

    private void btnCancelClick() {
        if (callBack != null) {
            callBack.cancelCallBack();
        }
    }

    @Override
    public void show() {
        super.show();
        verifyPinErrorInfoView.setVisibility(View.GONE);
    }

    public interface CallBack {
        void okCallBack(String pin);

        void cancelCallBack();
    }
}
